package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataServiceApplication invokes the dataworks_public.GetDataServiceApplication API synchronously
func (client *Client) GetDataServiceApplication(request *GetDataServiceApplicationRequest) (response *GetDataServiceApplicationResponse, err error) {
	response = CreateGetDataServiceApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataServiceApplicationWithChan invokes the dataworks_public.GetDataServiceApplication API asynchronously
func (client *Client) GetDataServiceApplicationWithChan(request *GetDataServiceApplicationRequest) (<-chan *GetDataServiceApplicationResponse, <-chan error) {
	responseChan := make(chan *GetDataServiceApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataServiceApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataServiceApplicationWithCallback invokes the dataworks_public.GetDataServiceApplication API asynchronously
func (client *Client) GetDataServiceApplicationWithCallback(request *GetDataServiceApplicationRequest, callback func(response *GetDataServiceApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataServiceApplicationResponse
		var err error
		defer close(result)
		response, err = client.GetDataServiceApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataServiceApplicationRequest is the request struct for api GetDataServiceApplication
type GetDataServiceApplicationRequest struct {
	*requests.RpcRequest
	TenantId      requests.Integer `position:"Body" name:"TenantId"`
	ApplicationId requests.Integer `position:"Body" name:"ApplicationId"`
	ProjectId     requests.Integer `position:"Body" name:"ProjectId"`
}

// GetDataServiceApplicationResponse is the response struct for api GetDataServiceApplication
type GetDataServiceApplicationResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetDataServiceApplicationRequest creates a request to invoke GetDataServiceApplication API
func CreateGetDataServiceApplicationRequest() (request *GetDataServiceApplicationRequest) {
	request = &GetDataServiceApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDataServiceApplication", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDataServiceApplicationResponse creates a response to parse from GetDataServiceApplication response
func CreateGetDataServiceApplicationResponse() (response *GetDataServiceApplicationResponse) {
	response = &GetDataServiceApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
