package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySensNodeInfo invokes the dataworks_public.QuerySensNodeInfo API synchronously
func (client *Client) QuerySensNodeInfo(request *QuerySensNodeInfoRequest) (response *QuerySensNodeInfoResponse, err error) {
	response = CreateQuerySensNodeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySensNodeInfoWithChan invokes the dataworks_public.QuerySensNodeInfo API asynchronously
func (client *Client) QuerySensNodeInfoWithChan(request *QuerySensNodeInfoRequest) (<-chan *QuerySensNodeInfoResponse, <-chan error) {
	responseChan := make(chan *QuerySensNodeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySensNodeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySensNodeInfoWithCallback invokes the dataworks_public.QuerySensNodeInfo API asynchronously
func (client *Client) QuerySensNodeInfoWithCallback(request *QuerySensNodeInfoRequest, callback func(response *QuerySensNodeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySensNodeInfoResponse
		var err error
		defer close(result)
		response, err = client.QuerySensNodeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySensNodeInfoRequest is the request struct for api QuerySensNodeInfo
type QuerySensNodeInfoRequest struct {
	*requests.RpcRequest
	PageNo        requests.Integer `position:"Body" name:"PageNo"`
	TenantId      string           `position:"Body" name:"TenantId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	SensitiveName string           `position:"Body" name:"SensitiveName"`
	TemplateId    string           `position:"Body" name:"TemplateId"`
	NodeId        string           `position:"Body" name:"NodeId"`
	Status        requests.Integer `position:"Body" name:"status"`
}

// QuerySensNodeInfoResponse is the response struct for api QuerySensNodeInfo
type QuerySensNodeInfoResponse struct {
	*responses.BaseResponse
}

// CreateQuerySensNodeInfoRequest creates a request to invoke QuerySensNodeInfo API
func CreateQuerySensNodeInfoRequest() (request *QuerySensNodeInfoRequest) {
	request = &QuerySensNodeInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "QuerySensNodeInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySensNodeInfoResponse creates a response to parse from QuerySensNodeInfo response
func CreateQuerySensNodeInfoResponse() (response *QuerySensNodeInfoResponse) {
	response = &QuerySensNodeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
