package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSetDcdnDomainCertificate invokes the dcdn.BatchSetDcdnDomainCertificate API synchronously
func (client *Client) BatchSetDcdnDomainCertificate(request *BatchSetDcdnDomainCertificateRequest) (response *BatchSetDcdnDomainCertificateResponse, err error) {
	response = CreateBatchSetDcdnDomainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSetDcdnDomainCertificateWithChan invokes the dcdn.BatchSetDcdnDomainCertificate API asynchronously
func (client *Client) BatchSetDcdnDomainCertificateWithChan(request *BatchSetDcdnDomainCertificateRequest) (<-chan *BatchSetDcdnDomainCertificateResponse, <-chan error) {
	responseChan := make(chan *BatchSetDcdnDomainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSetDcdnDomainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSetDcdnDomainCertificateWithCallback invokes the dcdn.BatchSetDcdnDomainCertificate API asynchronously
func (client *Client) BatchSetDcdnDomainCertificateWithCallback(request *BatchSetDcdnDomainCertificateRequest, callback func(response *BatchSetDcdnDomainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSetDcdnDomainCertificateResponse
		var err error
		defer close(result)
		response, err = client.BatchSetDcdnDomainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSetDcdnDomainCertificateRequest is the request struct for api BatchSetDcdnDomainCertificate
type BatchSetDcdnDomainCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertType      string           `position:"Query" name:"CertType"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
	CertName      string           `position:"Query" name:"CertName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
	Region        string           `position:"Query" name:"Region"`
}

// BatchSetDcdnDomainCertificateResponse is the response struct for api BatchSetDcdnDomainCertificate
type BatchSetDcdnDomainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchSetDcdnDomainCertificateRequest creates a request to invoke BatchSetDcdnDomainCertificate API
func CreateBatchSetDcdnDomainCertificateRequest() (request *BatchSetDcdnDomainCertificateRequest) {
	request = &BatchSetDcdnDomainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "BatchSetDcdnDomainCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchSetDcdnDomainCertificateResponse creates a response to parse from BatchSetDcdnDomainCertificate response
func CreateBatchSetDcdnDomainCertificateResponse() (response *BatchSetDcdnDomainCertificateResponse) {
	response = &BatchSetDcdnDomainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
