package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainLogExTtl invokes the dcdn.DescribeDcdnDomainLogExTtl API synchronously
func (client *Client) DescribeDcdnDomainLogExTtl(request *DescribeDcdnDomainLogExTtlRequest) (response *DescribeDcdnDomainLogExTtlResponse, err error) {
	response = CreateDescribeDcdnDomainLogExTtlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainLogExTtlWithChan invokes the dcdn.DescribeDcdnDomainLogExTtl API asynchronously
func (client *Client) DescribeDcdnDomainLogExTtlWithChan(request *DescribeDcdnDomainLogExTtlRequest) (<-chan *DescribeDcdnDomainLogExTtlResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainLogExTtlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainLogExTtl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainLogExTtlWithCallback invokes the dcdn.DescribeDcdnDomainLogExTtl API asynchronously
func (client *Client) DescribeDcdnDomainLogExTtlWithCallback(request *DescribeDcdnDomainLogExTtlRequest, callback func(response *DescribeDcdnDomainLogExTtlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainLogExTtlResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainLogExTtl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainLogExTtlRequest is the request struct for api DescribeDcdnDomainLogExTtl
type DescribeDcdnDomainLogExTtlRequest struct {
	*requests.RpcRequest
	LogType    string           `position:"Query" name:"LogType"`
	DomainName string           `position:"Query" name:"DomainName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	EndTime    string           `position:"Query" name:"EndTime"`
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnDomainLogExTtlResponse is the response struct for api DescribeDcdnDomainLogExTtl
type DescribeDcdnDomainLogExTtlResponse struct {
	*responses.BaseResponse
	RequestId        string                                       `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetailsInDescribeDcdnDomainLogExTtl `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeDcdnDomainLogExTtlRequest creates a request to invoke DescribeDcdnDomainLogExTtl API
func CreateDescribeDcdnDomainLogExTtlRequest() (request *DescribeDcdnDomainLogExTtlRequest) {
	request = &DescribeDcdnDomainLogExTtlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainLogExTtl", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainLogExTtlResponse creates a response to parse from DescribeDcdnDomainLogExTtl response
func CreateDescribeDcdnDomainLogExTtlResponse() (response *DescribeDcdnDomainLogExTtlResponse) {
	response = &DescribeDcdnDomainLogExTtlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
