package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDdosAllEventList invokes the dcdn.DescribeDdosAllEventList API synchronously
func (client *Client) DescribeDdosAllEventList(request *DescribeDdosAllEventListRequest) (response *DescribeDdosAllEventListResponse, err error) {
	response = CreateDescribeDdosAllEventListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDdosAllEventListWithChan invokes the dcdn.DescribeDdosAllEventList API asynchronously
func (client *Client) DescribeDdosAllEventListWithChan(request *DescribeDdosAllEventListRequest) (<-chan *DescribeDdosAllEventListResponse, <-chan error) {
	responseChan := make(chan *DescribeDdosAllEventListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDdosAllEventList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDdosAllEventListWithCallback invokes the dcdn.DescribeDdosAllEventList API asynchronously
func (client *Client) DescribeDdosAllEventListWithCallback(request *DescribeDdosAllEventListRequest, callback func(response *DescribeDdosAllEventListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDdosAllEventListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDdosAllEventList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDdosAllEventListRequest is the request struct for api DescribeDdosAllEventList
type DescribeDdosAllEventListRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	EndTime    string           `position:"Query" name:"EndTime"`
	EventType  string           `position:"Query" name:"EventType"`
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDdosAllEventListResponse is the response struct for api DescribeDdosAllEventList
type DescribeDdosAllEventListResponse struct {
	*responses.BaseResponse
	RequestId  string                  `json:"RequestId" xml:"RequestId"`
	Total      int64                   `json:"Total" xml:"Total"`
	PageNumber int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                     `json:"PageSize" xml:"PageSize"`
	DataList   []DdosDomainAttackEvent `json:"DataList" xml:"DataList"`
}

// CreateDescribeDdosAllEventListRequest creates a request to invoke DescribeDdosAllEventList API
func CreateDescribeDdosAllEventListRequest() (request *DescribeDdosAllEventListRequest) {
	request = &DescribeDdosAllEventListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDdosAllEventList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDdosAllEventListResponse creates a response to parse from DescribeDdosAllEventList response
func CreateDescribeDdosAllEventListResponse() (response *DescribeDdosAllEventListResponse) {
	response = &DescribeDdosAllEventListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
