package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccessGroup invokes the dfs.GetAccessGroup API synchronously
func (client *Client) GetAccessGroup(request *GetAccessGroupRequest) (response *GetAccessGroupResponse, err error) {
	response = CreateGetAccessGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccessGroupWithChan invokes the dfs.GetAccessGroup API asynchronously
func (client *Client) GetAccessGroupWithChan(request *GetAccessGroupRequest) (<-chan *GetAccessGroupResponse, <-chan error) {
	responseChan := make(chan *GetAccessGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccessGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccessGroupWithCallback invokes the dfs.GetAccessGroup API asynchronously
func (client *Client) GetAccessGroupWithCallback(request *GetAccessGroupRequest, callback func(response *GetAccessGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccessGroupResponse
		var err error
		defer close(result)
		response, err = client.GetAccessGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccessGroupRequest is the request struct for api GetAccessGroup
type GetAccessGroupRequest struct {
	*requests.RpcRequest
	AccessGroupId string `position:"Query" name:"AccessGroupId"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
}

// GetAccessGroupResponse is the response struct for api GetAccessGroup
type GetAccessGroupResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	AccessGroup AccessGroup `json:"AccessGroup" xml:"AccessGroup"`
}

// CreateGetAccessGroupRequest creates a request to invoke GetAccessGroup API
func CreateGetAccessGroupRequest() (request *GetAccessGroupRequest) {
	request = &GetAccessGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "GetAccessGroup", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccessGroupResponse creates a response to parse from GetAccessGroup response
func CreateGetAccessGroupResponse() (response *GetAccessGroupResponse) {
	response = &GetAccessGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
