package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProxyAccess invokes the dms_enterprise.GetProxyAccess API synchronously
func (client *Client) GetProxyAccess(request *GetProxyAccessRequest) (response *GetProxyAccessResponse, err error) {
	response = CreateGetProxyAccessResponse()
	err = client.DoAction(request, response)
	return
}

// GetProxyAccessWithChan invokes the dms_enterprise.GetProxyAccess API asynchronously
func (client *Client) GetProxyAccessWithChan(request *GetProxyAccessRequest) (<-chan *GetProxyAccessResponse, <-chan error) {
	responseChan := make(chan *GetProxyAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProxyAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProxyAccessWithCallback invokes the dms_enterprise.GetProxyAccess API asynchronously
func (client *Client) GetProxyAccessWithCallback(request *GetProxyAccessRequest, callback func(response *GetProxyAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProxyAccessResponse
		var err error
		defer close(result)
		response, err = client.GetProxyAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProxyAccessRequest is the request struct for api GetProxyAccess
type GetProxyAccessRequest struct {
	*requests.RpcRequest
	ProxyAccessId requests.Integer `position:"Query" name:"ProxyAccessId"`
	Tid           requests.Integer `position:"Query" name:"Tid"`
}

// GetProxyAccessResponse is the response struct for api GetProxyAccess
type GetProxyAccessResponse struct {
	*responses.BaseResponse
	RequestId    string      `json:"RequestId" xml:"RequestId"`
	Success      bool        `json:"Success" xml:"Success"`
	ErrorMessage string      `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string      `json:"ErrorCode" xml:"ErrorCode"`
	ProxyAccess  ProxyAccess `json:"ProxyAccess" xml:"ProxyAccess"`
}

// CreateGetProxyAccessRequest creates a request to invoke GetProxyAccess API
func CreateGetProxyAccessRequest() (request *GetProxyAccessRequest) {
	request = &GetProxyAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetProxyAccess", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetProxyAccessResponse creates a response to parse from GetProxyAccess response
func CreateGetProxyAccessResponse() (response *GetProxyAccessResponse) {
	response = &GetProxyAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
