package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetWorkflowExtraInfo invokes the dms_enterprise.SetWorkflowExtraInfo API synchronously
func (client *Client) SetWorkflowExtraInfo(request *SetWorkflowExtraInfoRequest) (response *SetWorkflowExtraInfoResponse, err error) {
	response = CreateSetWorkflowExtraInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SetWorkflowExtraInfoWithChan invokes the dms_enterprise.SetWorkflowExtraInfo API asynchronously
func (client *Client) SetWorkflowExtraInfoWithChan(request *SetWorkflowExtraInfoRequest) (<-chan *SetWorkflowExtraInfoResponse, <-chan error) {
	responseChan := make(chan *SetWorkflowExtraInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetWorkflowExtraInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetWorkflowExtraInfoWithCallback invokes the dms_enterprise.SetWorkflowExtraInfo API asynchronously
func (client *Client) SetWorkflowExtraInfoWithCallback(request *SetWorkflowExtraInfoRequest, callback func(response *SetWorkflowExtraInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetWorkflowExtraInfoResponse
		var err error
		defer close(result)
		response, err = client.SetWorkflowExtraInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetWorkflowExtraInfoRequest is the request struct for api SetWorkflowExtraInfo
type SetWorkflowExtraInfoRequest struct {
	*requests.RpcRequest
	ThirdpartyWorkflowComment string           `position:"Query" name:"ThirdpartyWorkflowComment"`
	RenderAgree               requests.Boolean `position:"Query" name:"RenderAgree"`
	Tid                       requests.Integer `position:"Query" name:"Tid"`
	WorkflowInstanceId        requests.Integer `position:"Query" name:"WorkflowInstanceId"`
	RenderCancel              requests.Boolean `position:"Query" name:"RenderCancel"`
	RenderAddApprovalNode     requests.Boolean `position:"Query" name:"RenderAddApprovalNode"`
	RenderTransfer            requests.Boolean `position:"Query" name:"RenderTransfer"`
	RenderReject              requests.Boolean `position:"Query" name:"RenderReject"`
	ThirdpartyWorkflowUrl     string           `position:"Query" name:"ThirdpartyWorkflowUrl"`
}

// SetWorkflowExtraInfoResponse is the response struct for api SetWorkflowExtraInfo
type SetWorkflowExtraInfoResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateSetWorkflowExtraInfoRequest creates a request to invoke SetWorkflowExtraInfo API
func CreateSetWorkflowExtraInfoRequest() (request *SetWorkflowExtraInfoRequest) {
	request = &SetWorkflowExtraInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "SetWorkflowExtraInfo", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetWorkflowExtraInfoResponse creates a response to parse from SetWorkflowExtraInfo response
func CreateSetWorkflowExtraInfoResponse() (response *SetWorkflowExtraInfoResponse) {
	response = &SetWorkflowExtraInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
