package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIntlFixedPriceDomainOrder invokes the domain.CreateIntlFixedPriceDomainOrder API synchronously
func (client *Client) CreateIntlFixedPriceDomainOrder(request *CreateIntlFixedPriceDomainOrderRequest) (response *CreateIntlFixedPriceDomainOrderResponse, err error) {
	response = CreateCreateIntlFixedPriceDomainOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIntlFixedPriceDomainOrderWithChan invokes the domain.CreateIntlFixedPriceDomainOrder API asynchronously
func (client *Client) CreateIntlFixedPriceDomainOrderWithChan(request *CreateIntlFixedPriceDomainOrderRequest) (<-chan *CreateIntlFixedPriceDomainOrderResponse, <-chan error) {
	responseChan := make(chan *CreateIntlFixedPriceDomainOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIntlFixedPriceDomainOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIntlFixedPriceDomainOrderWithCallback invokes the domain.CreateIntlFixedPriceDomainOrder API asynchronously
func (client *Client) CreateIntlFixedPriceDomainOrderWithCallback(request *CreateIntlFixedPriceDomainOrderRequest, callback func(response *CreateIntlFixedPriceDomainOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIntlFixedPriceDomainOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateIntlFixedPriceDomainOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIntlFixedPriceDomainOrderRequest is the request struct for api CreateIntlFixedPriceDomainOrder
type CreateIntlFixedPriceDomainOrderRequest struct {
	*requests.RpcRequest
	AutoPay       requests.Boolean `position:"Query" name:"AutoPay"`
	ContactId     requests.Integer `position:"Query" name:"ContactId"`
	ExpectedPrice requests.Integer `position:"Query" name:"ExpectedPrice"`
	Domain        string           `position:"Query" name:"Domain"`
}

// CreateIntlFixedPriceDomainOrderResponse is the response struct for api CreateIntlFixedPriceDomainOrder
type CreateIntlFixedPriceDomainOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    Module `json:"Module" xml:"Module"`
}

// CreateCreateIntlFixedPriceDomainOrderRequest creates a request to invoke CreateIntlFixedPriceDomainOrder API
func CreateCreateIntlFixedPriceDomainOrderRequest() (request *CreateIntlFixedPriceDomainOrderRequest) {
	request = &CreateIntlFixedPriceDomainOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "CreateIntlFixedPriceDomainOrder", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateIntlFixedPriceDomainOrderResponse creates a response to parse from CreateIntlFixedPriceDomainOrder response
func CreateCreateIntlFixedPriceDomainOrderResponse() (response *CreateIntlFixedPriceDomainOrderResponse) {
	response = &CreateIntlFixedPriceDomainOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
