package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeInstanceAzone invokes the drds.ChangeInstanceAzone API synchronously
func (client *Client) ChangeInstanceAzone(request *ChangeInstanceAzoneRequest) (response *ChangeInstanceAzoneResponse, err error) {
	response = CreateChangeInstanceAzoneResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeInstanceAzoneWithChan invokes the drds.ChangeInstanceAzone API asynchronously
func (client *Client) ChangeInstanceAzoneWithChan(request *ChangeInstanceAzoneRequest) (<-chan *ChangeInstanceAzoneResponse, <-chan error) {
	responseChan := make(chan *ChangeInstanceAzoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeInstanceAzone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeInstanceAzoneWithCallback invokes the drds.ChangeInstanceAzone API asynchronously
func (client *Client) ChangeInstanceAzoneWithCallback(request *ChangeInstanceAzoneRequest, callback func(response *ChangeInstanceAzoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeInstanceAzoneResponse
		var err error
		defer close(result)
		response, err = client.ChangeInstanceAzone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeInstanceAzoneRequest is the request struct for api ChangeInstanceAzone
type ChangeInstanceAzoneRequest struct {
	*requests.RpcRequest
	TargetAzoneId  string           `position:"Query" name:"TargetAzoneId"`
	DrdsRegionId   string           `position:"Query" name:"DrdsRegionId"`
	DrdsInstanceId string           `position:"Query" name:"DrdsInstanceId"`
	OriginAzoneId  string           `position:"Query" name:"OriginAzoneId"`
	ChangeVSwitch  requests.Boolean `position:"Query" name:"ChangeVSwitch"`
	NewVSwitch     string           `position:"Query" name:"NewVSwitch"`
}

// ChangeInstanceAzoneResponse is the response struct for api ChangeInstanceAzone
type ChangeInstanceAzoneResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateChangeInstanceAzoneRequest creates a request to invoke ChangeInstanceAzone API
func CreateChangeInstanceAzoneRequest() (request *ChangeInstanceAzoneRequest) {
	request = &ChangeInstanceAzoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ChangeInstanceAzone", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeInstanceAzoneResponse creates a response to parse from ChangeInstanceAzone response
func CreateChangeInstanceAzoneResponse() (response *ChangeInstanceAzoneResponse) {
	response = &ChangeInstanceAzoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
