package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePickUpWaybillPreQuery invokes the dyplsapi.CreatePickUpWaybillPreQuery API synchronously
func (client *Client) CreatePickUpWaybillPreQuery(request *CreatePickUpWaybillPreQueryRequest) (response *CreatePickUpWaybillPreQueryResponse, err error) {
	response = CreateCreatePickUpWaybillPreQueryResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePickUpWaybillPreQueryWithChan invokes the dyplsapi.CreatePickUpWaybillPreQuery API asynchronously
func (client *Client) CreatePickUpWaybillPreQueryWithChan(request *CreatePickUpWaybillPreQueryRequest) (<-chan *CreatePickUpWaybillPreQueryResponse, <-chan error) {
	responseChan := make(chan *CreatePickUpWaybillPreQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePickUpWaybillPreQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePickUpWaybillPreQueryWithCallback invokes the dyplsapi.CreatePickUpWaybillPreQuery API asynchronously
func (client *Client) CreatePickUpWaybillPreQueryWithCallback(request *CreatePickUpWaybillPreQueryRequest, callback func(response *CreatePickUpWaybillPreQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePickUpWaybillPreQueryResponse
		var err error
		defer close(result)
		response, err = client.CreatePickUpWaybillPreQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePickUpWaybillPreQueryRequest is the request struct for api CreatePickUpWaybillPreQuery
type CreatePickUpWaybillPreQueryRequest struct {
	*requests.RpcRequest
	PreWeight      string                                   `position:"Query" name:"PreWeight"`
	OrderChannels  string                                   `position:"Query" name:"OrderChannels"`
	OuterOrderCode string                                   `position:"Query" name:"OuterOrderCode"`
	ConsigneeInfo  CreatePickUpWaybillPreQueryConsigneeInfo `position:"Query" name:"ConsigneeInfo"  type:"Struct"`
	CpCode         string                                   `position:"Query" name:"CpCode"`
	ContentType    string                                   `position:"Header" name:"Content-Type"`
	SenderInfo     CreatePickUpWaybillPreQuerySenderInfo    `position:"Query" name:"SenderInfo"  type:"Struct"`
}

// CreatePickUpWaybillPreQueryConsigneeInfo is a repeated param struct in CreatePickUpWaybillPreQueryRequest
type CreatePickUpWaybillPreQueryConsigneeInfo struct {
	Name        string                                              `name:"Name"`
	Mobile      string                                              `name:"Mobile"`
	AddressInfo CreatePickUpWaybillPreQueryConsigneeInfoAddressInfo `name:"AddressInfo" type:"Struct"`
}

// CreatePickUpWaybillPreQuerySenderInfo is a repeated param struct in CreatePickUpWaybillPreQueryRequest
type CreatePickUpWaybillPreQuerySenderInfo struct {
	Name        string                                           `name:"Name"`
	Mobile      string                                           `name:"Mobile"`
	AddressInfo CreatePickUpWaybillPreQuerySenderInfoAddressInfo `name:"AddressInfo" type:"Struct"`
}

// CreatePickUpWaybillPreQueryConsigneeInfoAddressInfo is a repeated param struct in CreatePickUpWaybillPreQueryRequest
type CreatePickUpWaybillPreQueryConsigneeInfoAddressInfo struct {
	ProvinceName  string `name:"ProvinceName"`
	CityName      string `name:"CityName"`
	AreaName      string `name:"AreaName"`
	TownName      string `name:"TownName"`
	AddressDetail string `name:"AddressDetail"`
}

// CreatePickUpWaybillPreQuerySenderInfoAddressInfo is a repeated param struct in CreatePickUpWaybillPreQueryRequest
type CreatePickUpWaybillPreQuerySenderInfoAddressInfo struct {
	ProvinceName  string `name:"ProvinceName"`
	CityName      string `name:"CityName"`
	AreaName      string `name:"AreaName"`
	TownName      string `name:"TownName"`
	AddressDetail string `name:"AddressDetail"`
}

// CreatePickUpWaybillPreQueryResponse is the response struct for api CreatePickUpWaybillPreQuery
type CreatePickUpWaybillPreQueryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreatePickUpWaybillPreQueryRequest creates a request to invoke CreatePickUpWaybillPreQuery API
func CreateCreatePickUpWaybillPreQueryRequest() (request *CreatePickUpWaybillPreQueryRequest) {
	request = &CreatePickUpWaybillPreQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "CreatePickUpWaybillPreQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateCreatePickUpWaybillPreQueryResponse creates a response to parse from CreatePickUpWaybillPreQuery response
func CreateCreatePickUpWaybillPreQueryResponse() (response *CreatePickUpWaybillPreQueryResponse) {
	response = &CreatePickUpWaybillPreQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
