package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySubscriptionDetail invokes the dyplsapi.QuerySubscriptionDetail API synchronously
func (client *Client) QuerySubscriptionDetail(request *QuerySubscriptionDetailRequest) (response *QuerySubscriptionDetailResponse, err error) {
	response = CreateQuerySubscriptionDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySubscriptionDetailWithChan invokes the dyplsapi.QuerySubscriptionDetail API asynchronously
func (client *Client) QuerySubscriptionDetailWithChan(request *QuerySubscriptionDetailRequest) (<-chan *QuerySubscriptionDetailResponse, <-chan error) {
	responseChan := make(chan *QuerySubscriptionDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySubscriptionDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySubscriptionDetailWithCallback invokes the dyplsapi.QuerySubscriptionDetail API asynchronously
func (client *Client) QuerySubscriptionDetailWithCallback(request *QuerySubscriptionDetailRequest, callback func(response *QuerySubscriptionDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySubscriptionDetailResponse
		var err error
		defer close(result)
		response, err = client.QuerySubscriptionDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySubscriptionDetailRequest is the request struct for api QuerySubscriptionDetail
type QuerySubscriptionDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProductType          string           `position:"Query" name:"ProductType"`
	SubsId               string           `position:"Query" name:"SubsId"`
	PhoneNoX             string           `position:"Query" name:"PhoneNoX"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
}

// QuerySubscriptionDetailResponse is the response struct for api QuerySubscriptionDetail
type QuerySubscriptionDetailResponse struct {
	*responses.BaseResponse
	Code                string              `json:"Code" xml:"Code"`
	Message             string              `json:"Message" xml:"Message"`
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	SecretBindDetailDTO SecretBindDetailDTO `json:"SecretBindDetailDTO" xml:"SecretBindDetailDTO"`
}

// CreateQuerySubscriptionDetailRequest creates a request to invoke QuerySubscriptionDetail API
func CreateQuerySubscriptionDetailRequest() (request *QuerySubscriptionDetailRequest) {
	request = &QuerySubscriptionDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "QuerySubscriptionDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySubscriptionDetailResponse creates a response to parse from QuerySubscriptionDetail response
func CreateQuerySubscriptionDetailResponse() (response *QuerySubscriptionDetailResponse) {
	response = &QuerySubscriptionDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
