package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiskReplicaGroup invokes the ebs.ModifyDiskReplicaGroup API synchronously
func (client *Client) ModifyDiskReplicaGroup(request *ModifyDiskReplicaGroupRequest) (response *ModifyDiskReplicaGroupResponse, err error) {
	response = CreateModifyDiskReplicaGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiskReplicaGroupWithChan invokes the ebs.ModifyDiskReplicaGroup API asynchronously
func (client *Client) ModifyDiskReplicaGroupWithChan(request *ModifyDiskReplicaGroupRequest) (<-chan *ModifyDiskReplicaGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDiskReplicaGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiskReplicaGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiskReplicaGroupWithCallback invokes the ebs.ModifyDiskReplicaGroup API asynchronously
func (client *Client) ModifyDiskReplicaGroupWithCallback(request *ModifyDiskReplicaGroupRequest, callback func(response *ModifyDiskReplicaGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiskReplicaGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiskReplicaGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiskReplicaGroupRequest is the request struct for api ModifyDiskReplicaGroup
type ModifyDiskReplicaGroupRequest struct {
	*requests.RpcRequest
	ClientToken    string           `position:"Query" name:"ClientToken"`
	Description    string           `position:"Query" name:"Description"`
	Bandwidth      requests.Integer `position:"Query" name:"Bandwidth"`
	ReplicaGroupId string           `position:"Query" name:"ReplicaGroupId"`
	GroupName      string           `position:"Query" name:"GroupName"`
	RPO            requests.Integer `position:"Query" name:"RPO"`
}

// ModifyDiskReplicaGroupResponse is the response struct for api ModifyDiskReplicaGroup
type ModifyDiskReplicaGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDiskReplicaGroupRequest creates a request to invoke ModifyDiskReplicaGroup API
func CreateModifyDiskReplicaGroupRequest() (request *ModifyDiskReplicaGroupRequest) {
	request = &ModifyDiskReplicaGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "ModifyDiskReplicaGroup", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDiskReplicaGroupResponse creates a response to parse from ModifyDiskReplicaGroup response
func CreateModifyDiskReplicaGroupResponse() (response *ModifyDiskReplicaGroupResponse) {
	response = &ModifyDiskReplicaGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
