package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDesktopOversoldUserGroup invokes the ecd.AddDesktopOversoldUserGroup API synchronously
func (client *Client) AddDesktopOversoldUserGroup(request *AddDesktopOversoldUserGroupRequest) (response *AddDesktopOversoldUserGroupResponse, err error) {
	response = CreateAddDesktopOversoldUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddDesktopOversoldUserGroupWithChan invokes the ecd.AddDesktopOversoldUserGroup API asynchronously
func (client *Client) AddDesktopOversoldUserGroupWithChan(request *AddDesktopOversoldUserGroupRequest) (<-chan *AddDesktopOversoldUserGroupResponse, <-chan error) {
	responseChan := make(chan *AddDesktopOversoldUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDesktopOversoldUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDesktopOversoldUserGroupWithCallback invokes the ecd.AddDesktopOversoldUserGroup API asynchronously
func (client *Client) AddDesktopOversoldUserGroupWithCallback(request *AddDesktopOversoldUserGroupRequest, callback func(response *AddDesktopOversoldUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDesktopOversoldUserGroupResponse
		var err error
		defer close(result)
		response, err = client.AddDesktopOversoldUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDesktopOversoldUserGroupRequest is the request struct for api AddDesktopOversoldUserGroup
type AddDesktopOversoldUserGroupRequest struct {
	*requests.RpcRequest
	OversoldGroupId string                            `position:"Query" name:"OversoldGroupId"`
	ImageId         string                            `position:"Query" name:"ImageId"`
	Name            string                            `position:"Query" name:"Name"`
	Tag             *[]AddDesktopOversoldUserGroupTag `position:"Query" name:"Tag"  type:"Repeated"`
	PolicyGroupId   string                            `position:"Query" name:"PolicyGroupId"`
}

// AddDesktopOversoldUserGroupTag is a repeated param struct in AddDesktopOversoldUserGroupRequest
type AddDesktopOversoldUserGroupTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// AddDesktopOversoldUserGroupResponse is the response struct for api AddDesktopOversoldUserGroup
type AddDesktopOversoldUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddDesktopOversoldUserGroupRequest creates a request to invoke AddDesktopOversoldUserGroup API
func CreateAddDesktopOversoldUserGroupRequest() (request *AddDesktopOversoldUserGroupRequest) {
	request = &AddDesktopOversoldUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AddDesktopOversoldUserGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDesktopOversoldUserGroupResponse creates a response to parse from AddDesktopOversoldUserGroup response
func CreateAddDesktopOversoldUserGroupResponse() (response *AddDesktopOversoldUserGroupResponse) {
	response = &AddDesktopOversoldUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
