package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConnectionTicket invokes the ecd.GetConnectionTicket API synchronously
func (client *Client) GetConnectionTicket(request *GetConnectionTicketRequest) (response *GetConnectionTicketResponse, err error) {
	response = CreateGetConnectionTicketResponse()
	err = client.DoAction(request, response)
	return
}

// GetConnectionTicketWithChan invokes the ecd.GetConnectionTicket API asynchronously
func (client *Client) GetConnectionTicketWithChan(request *GetConnectionTicketRequest) (<-chan *GetConnectionTicketResponse, <-chan error) {
	responseChan := make(chan *GetConnectionTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConnectionTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConnectionTicketWithCallback invokes the ecd.GetConnectionTicket API asynchronously
func (client *Client) GetConnectionTicketWithCallback(request *GetConnectionTicketRequest, callback func(response *GetConnectionTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConnectionTicketResponse
		var err error
		defer close(result)
		response, err = client.GetConnectionTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConnectionTicketRequest is the request struct for api GetConnectionTicket
type GetConnectionTicketRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Uuid                 string           `position:"Query" name:"Uuid"`
	CommandContent       string           `position:"Query" name:"CommandContent"`
	Password             string           `position:"Query" name:"Password"`
	EndUserId            string           `position:"Query" name:"EndUserId"`
	DesktopId            string           `position:"Query" name:"DesktopId"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetConnectionTicketResponse is the response struct for api GetConnectionTicket
type GetConnectionTicketResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TaskStatus string `json:"TaskStatus" xml:"TaskStatus"`
	Ticket     string `json:"Ticket" xml:"Ticket"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateGetConnectionTicketRequest creates a request to invoke GetConnectionTicket API
func CreateGetConnectionTicketRequest() (request *GetConnectionTicketRequest) {
	request = &GetConnectionTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "GetConnectionTicket", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetConnectionTicketResponse creates a response to parse from GetConnectionTicket response
func CreateGetConnectionTicketResponse() (response *GetConnectionTicketResponse) {
	response = &GetConnectionTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
