package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCloudDrivePermission invokes the ecd.ModifyCloudDrivePermission API synchronously
func (client *Client) ModifyCloudDrivePermission(request *ModifyCloudDrivePermissionRequest) (response *ModifyCloudDrivePermissionResponse, err error) {
	response = CreateModifyCloudDrivePermissionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCloudDrivePermissionWithChan invokes the ecd.ModifyCloudDrivePermission API asynchronously
func (client *Client) ModifyCloudDrivePermissionWithChan(request *ModifyCloudDrivePermissionRequest) (<-chan *ModifyCloudDrivePermissionResponse, <-chan error) {
	responseChan := make(chan *ModifyCloudDrivePermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCloudDrivePermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCloudDrivePermissionWithCallback invokes the ecd.ModifyCloudDrivePermission API asynchronously
func (client *Client) ModifyCloudDrivePermissionWithCallback(request *ModifyCloudDrivePermissionRequest, callback func(response *ModifyCloudDrivePermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCloudDrivePermissionResponse
		var err error
		defer close(result)
		response, err = client.ModifyCloudDrivePermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCloudDrivePermissionRequest is the request struct for api ModifyCloudDrivePermission
type ModifyCloudDrivePermissionRequest struct {
	*requests.RpcRequest
	DownloadEndUserIds       *[]string `position:"Query" name:"DownloadEndUserIds"  type:"Repeated"`
	CdsId                    string    `position:"Query" name:"CdsId"`
	DownloadUploadEndUserIds *[]string `position:"Query" name:"DownloadUploadEndUserIds"  type:"Repeated"`
}

// ModifyCloudDrivePermissionResponse is the response struct for api ModifyCloudDrivePermission
type ModifyCloudDrivePermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCloudDrivePermissionRequest creates a request to invoke ModifyCloudDrivePermission API
func CreateModifyCloudDrivePermissionRequest() (request *ModifyCloudDrivePermissionRequest) {
	request = &ModifyCloudDrivePermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyCloudDrivePermission", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCloudDrivePermissionResponse creates a response to parse from ModifyCloudDrivePermission response
func CreateModifyCloudDrivePermissionResponse() (response *ModifyCloudDrivePermissionResponse) {
	response = &ModifyCloudDrivePermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
