package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopGroup invokes the ecd.ModifyDesktopGroup API synchronously
func (client *Client) ModifyDesktopGroup(request *ModifyDesktopGroupRequest) (response *ModifyDesktopGroupResponse, err error) {
	response = CreateModifyDesktopGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopGroupWithChan invokes the ecd.ModifyDesktopGroup API asynchronously
func (client *Client) ModifyDesktopGroupWithChan(request *ModifyDesktopGroupRequest) (<-chan *ModifyDesktopGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopGroupWithCallback invokes the ecd.ModifyDesktopGroup API asynchronously
func (client *Client) ModifyDesktopGroupWithCallback(request *ModifyDesktopGroupRequest, callback func(response *ModifyDesktopGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopGroupRequest is the request struct for api ModifyDesktopGroup
type ModifyDesktopGroupRequest struct {
	*requests.RpcRequest
	Classify               string           `position:"Query" name:"Classify"`
	ImageId                string           `position:"Query" name:"ImageId"`
	ScaleStrategyId        string           `position:"Query" name:"ScaleStrategyId"`
	DisableSessionConfig   requests.Boolean `position:"Query" name:"DisableSessionConfig"`
	BindAmount             requests.Integer `position:"Query" name:"BindAmount"`
	LoadPolicy             requests.Integer `position:"Query" name:"LoadPolicy"`
	DesktopGroupName       string           `position:"Query" name:"DesktopGroupName"`
	AllowBufferCount       requests.Integer `position:"Query" name:"AllowBufferCount"`
	PolicyGroupIds         *[]string        `position:"Query" name:"PolicyGroupIds"  type:"Repeated"`
	IdleDisconnectDuration requests.Integer `position:"Query" name:"IdleDisconnectDuration"`
	DesktopGroupId         string           `position:"Query" name:"DesktopGroupId"`
	MinDesktopsCount       requests.Integer `position:"Query" name:"MinDesktopsCount"`
	MaxDesktopsCount       requests.Integer `position:"Query" name:"MaxDesktopsCount"`
	FileSystemId           string           `position:"Query" name:"FileSystemId"`
	AllowAutoSetup         requests.Integer `position:"Query" name:"AllowAutoSetup"`
	Comments               string           `position:"Query" name:"Comments"`
	ResetType              requests.Integer `position:"Query" name:"ResetType"`
	OwnBundleId            string           `position:"Query" name:"OwnBundleId"`
	StopDuration           requests.Integer `position:"Query" name:"StopDuration"`
	RatioThreshold         requests.Float   `position:"Query" name:"RatioThreshold"`
	KeepDuration           requests.Integer `position:"Query" name:"KeepDuration"`
	ConnectDuration        requests.Integer `position:"Query" name:"ConnectDuration"`
	ProfileFollowSwitch    requests.Boolean `position:"Query" name:"ProfileFollowSwitch"`
	BuyDesktopsCount       requests.Integer `position:"Query" name:"BuyDesktopsCount"`
	PolicyGroupId          string           `position:"Query" name:"PolicyGroupId"`
}

// ModifyDesktopGroupResponse is the response struct for api ModifyDesktopGroup
type ModifyDesktopGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDesktopGroupRequest creates a request to invoke ModifyDesktopGroup API
func CreateModifyDesktopGroupRequest() (request *ModifyDesktopGroupRequest) {
	request = &ModifyDesktopGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopGroupResponse creates a response to parse from ModifyDesktopGroup response
func CreateModifyDesktopGroupResponse() (response *ModifyDesktopGroupResponse) {
	response = &ModifyDesktopGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
