package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNetworkPackageEnabled invokes the ecd.ModifyNetworkPackageEnabled API synchronously
func (client *Client) ModifyNetworkPackageEnabled(request *ModifyNetworkPackageEnabledRequest) (response *ModifyNetworkPackageEnabledResponse, err error) {
	response = CreateModifyNetworkPackageEnabledResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNetworkPackageEnabledWithChan invokes the ecd.ModifyNetworkPackageEnabled API asynchronously
func (client *Client) ModifyNetworkPackageEnabledWithChan(request *ModifyNetworkPackageEnabledRequest) (<-chan *ModifyNetworkPackageEnabledResponse, <-chan error) {
	responseChan := make(chan *ModifyNetworkPackageEnabledResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNetworkPackageEnabled(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNetworkPackageEnabledWithCallback invokes the ecd.ModifyNetworkPackageEnabled API asynchronously
func (client *Client) ModifyNetworkPackageEnabledWithCallback(request *ModifyNetworkPackageEnabledRequest, callback func(response *ModifyNetworkPackageEnabledResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNetworkPackageEnabledResponse
		var err error
		defer close(result)
		response, err = client.ModifyNetworkPackageEnabled(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNetworkPackageEnabledRequest is the request struct for api ModifyNetworkPackageEnabled
type ModifyNetworkPackageEnabledRequest struct {
	*requests.RpcRequest
	NetworkPackageId string           `position:"Query" name:"NetworkPackageId"`
	Enabled          requests.Boolean `position:"Query" name:"Enabled"`
}

// ModifyNetworkPackageEnabledResponse is the response struct for api ModifyNetworkPackageEnabled
type ModifyNetworkPackageEnabledResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNetworkPackageEnabledRequest creates a request to invoke ModifyNetworkPackageEnabled API
func CreateModifyNetworkPackageEnabledRequest() (request *ModifyNetworkPackageEnabledRequest) {
	request = &ModifyNetworkPackageEnabledRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyNetworkPackageEnabled", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNetworkPackageEnabledResponse creates a response to parse from ModifyNetworkPackageEnabled response
func CreateModifyNetworkPackageEnabledResponse() (response *ModifyNetworkPackageEnabledResponse) {
	response = &ModifyNetworkPackageEnabledResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
