package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCloudAssistantSettings invokes the ecs.ModifyCloudAssistantSettings API synchronously
func (client *Client) ModifyCloudAssistantSettings(request *ModifyCloudAssistantSettingsRequest) (response *ModifyCloudAssistantSettingsResponse, err error) {
	response = CreateModifyCloudAssistantSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCloudAssistantSettingsWithChan invokes the ecs.ModifyCloudAssistantSettings API asynchronously
func (client *Client) ModifyCloudAssistantSettingsWithChan(request *ModifyCloudAssistantSettingsRequest) (<-chan *ModifyCloudAssistantSettingsResponse, <-chan error) {
	responseChan := make(chan *ModifyCloudAssistantSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCloudAssistantSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCloudAssistantSettingsWithCallback invokes the ecs.ModifyCloudAssistantSettings API asynchronously
func (client *Client) ModifyCloudAssistantSettingsWithCallback(request *ModifyCloudAssistantSettingsRequest, callback func(response *ModifyCloudAssistantSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCloudAssistantSettingsResponse
		var err error
		defer close(result)
		response, err = client.ModifyCloudAssistantSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCloudAssistantSettingsRequest is the request struct for api ModifyCloudAssistantSettings
type ModifyCloudAssistantSettingsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                               `position:"Query" name:"ResourceOwnerId"`
	AgentUpgradeConfig   ModifyCloudAssistantSettingsAgentUpgradeConfig `position:"Query" name:"AgentUpgradeConfig"  type:"Struct"`
	OssDeliveryConfig    ModifyCloudAssistantSettingsOssDeliveryConfig  `position:"Query" name:"OssDeliveryConfig"  type:"Struct"`
	SettingType          string                                         `position:"Query" name:"SettingType"`
	SlsDeliveryConfig    ModifyCloudAssistantSettingsSlsDeliveryConfig  `position:"Query" name:"SlsDeliveryConfig"  type:"Struct"`
	ResourceOwnerAccount string                                         `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                         `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                               `position:"Query" name:"OwnerId"`
}

// ModifyCloudAssistantSettingsAgentUpgradeConfig is a repeated param struct in ModifyCloudAssistantSettingsRequest
type ModifyCloudAssistantSettingsAgentUpgradeConfig struct {
	Enabled              string    `name:"Enabled"`
	AllowedUpgradeWindow *[]string `name:"AllowedUpgradeWindow" type:"Repeated"`
	TimeZone             string    `name:"TimeZone"`
}

// ModifyCloudAssistantSettingsOssDeliveryConfig is a repeated param struct in ModifyCloudAssistantSettingsRequest
type ModifyCloudAssistantSettingsOssDeliveryConfig struct {
	Enabled             string `name:"Enabled"`
	BucketName          string `name:"BucketName"`
	Prefix              string `name:"Prefix"`
	EncryptionType      string `name:"EncryptionType"`
	EncryptionAlgorithm string `name:"EncryptionAlgorithm"`
	EncryptionKeyId     string `name:"EncryptionKeyId"`
}

// ModifyCloudAssistantSettingsSlsDeliveryConfig is a repeated param struct in ModifyCloudAssistantSettingsRequest
type ModifyCloudAssistantSettingsSlsDeliveryConfig struct {
	Enabled      string `name:"Enabled"`
	ProjectName  string `name:"ProjectName"`
	LogstoreName string `name:"LogstoreName"`
}

// ModifyCloudAssistantSettingsResponse is the response struct for api ModifyCloudAssistantSettings
type ModifyCloudAssistantSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCloudAssistantSettingsRequest creates a request to invoke ModifyCloudAssistantSettings API
func CreateModifyCloudAssistantSettingsRequest() (request *ModifyCloudAssistantSettingsRequest) {
	request = &ModifyCloudAssistantSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyCloudAssistantSettings", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCloudAssistantSettingsResponse creates a response to parse from ModifyCloudAssistantSettings response
func CreateModifyCloudAssistantSettingsResponse() (response *ModifyCloudAssistantSettingsResponse) {
	response = &ModifyCloudAssistantSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
