package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateK8sResource invokes the edas.UpdateK8sResource API synchronously
func (client *Client) UpdateK8sResource(request *UpdateK8sResourceRequest) (response *UpdateK8sResourceResponse, err error) {
	response = CreateUpdateK8sResourceResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateK8sResourceWithChan invokes the edas.UpdateK8sResource API asynchronously
func (client *Client) UpdateK8sResourceWithChan(request *UpdateK8sResourceRequest) (<-chan *UpdateK8sResourceResponse, <-chan error) {
	responseChan := make(chan *UpdateK8sResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateK8sResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateK8sResourceWithCallback invokes the edas.UpdateK8sResource API asynchronously
func (client *Client) UpdateK8sResourceWithCallback(request *UpdateK8sResourceRequest, callback func(response *UpdateK8sResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateK8sResourceResponse
		var err error
		defer close(result)
		response, err = client.UpdateK8sResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateK8sResourceRequest is the request struct for api UpdateK8sResource
type UpdateK8sResourceRequest struct {
	*requests.RoaRequest
	Namespace       string `position:"Body" name:"Namespace"`
	ClusterId       string `position:"Body" name:"ClusterId"`
	ResourceContent string `position:"Body" name:"ResourceContent"`
}

// UpdateK8sResourceResponse is the response struct for api UpdateK8sResource
type UpdateK8sResourceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateK8sResourceRequest creates a request to invoke UpdateK8sResource API
func CreateUpdateK8sResourceRequest() (request *UpdateK8sResourceRequest) {
	request = &UpdateK8sResourceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateK8sResource", "/pop/v5/oam/update_k8s_resource_config", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateK8sResourceResponse creates a response to parse from UpdateK8sResource response
func CreateUpdateK8sResourceResponse() (response *UpdateK8sResourceResponse) {
	response = &UpdateK8sResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
