package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetErAttachment invokes the eflo.GetErAttachment API synchronously
func (client *Client) GetErAttachment(request *GetErAttachmentRequest) (response *GetErAttachmentResponse, err error) {
	response = CreateGetErAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// GetErAttachmentWithChan invokes the eflo.GetErAttachment API asynchronously
func (client *Client) GetErAttachmentWithChan(request *GetErAttachmentRequest) (<-chan *GetErAttachmentResponse, <-chan error) {
	responseChan := make(chan *GetErAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetErAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetErAttachmentWithCallback invokes the eflo.GetErAttachment API asynchronously
func (client *Client) GetErAttachmentWithCallback(request *GetErAttachmentRequest, callback func(response *GetErAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetErAttachmentResponse
		var err error
		defer close(result)
		response, err = client.GetErAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetErAttachmentRequest is the request struct for api GetErAttachment
type GetErAttachmentRequest struct {
	*requests.RpcRequest
	ErId           string `position:"Body" name:"ErId"`
	ErAttachmentId string `position:"Body" name:"ErAttachmentId"`
}

// GetErAttachmentResponse is the response struct for api GetErAttachment
type GetErAttachmentResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateGetErAttachmentRequest creates a request to invoke GetErAttachment API
func CreateGetErAttachmentRequest() (request *GetErAttachmentRequest) {
	request = &GetErAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "GetErAttachment", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetErAttachmentResponse creates a response to parse from GetErAttachment response
func CreateGetErAttachmentResponse() (response *GetErAttachmentResponse) {
	response = &GetErAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
