package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVccGrantRules invokes the eflo.ListVccGrantRules API synchronously
func (client *Client) ListVccGrantRules(request *ListVccGrantRulesRequest) (response *ListVccGrantRulesResponse, err error) {
	response = CreateListVccGrantRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVccGrantRulesWithChan invokes the eflo.ListVccGrantRules API asynchronously
func (client *Client) ListVccGrantRulesWithChan(request *ListVccGrantRulesRequest) (<-chan *ListVccGrantRulesResponse, <-chan error) {
	responseChan := make(chan *ListVccGrantRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVccGrantRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVccGrantRulesWithCallback invokes the eflo.ListVccGrantRules API asynchronously
func (client *Client) ListVccGrantRulesWithCallback(request *ListVccGrantRulesRequest, callback func(response *ListVccGrantRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVccGrantRulesResponse
		var err error
		defer close(result)
		response, err = client.ListVccGrantRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVccGrantRulesRequest is the request struct for api ListVccGrantRules
type ListVccGrantRulesRequest struct {
	*requests.RpcRequest
	GrantTenantId   string           `position:"Body" name:"GrantTenantId"`
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	ResourceGroupId string           `position:"Body" name:"ResourceGroupId"`
	GrantRuleId     string           `position:"Body" name:"GrantRuleId"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	ErId            string           `position:"Body" name:"ErId"`
	ForSelect       requests.Boolean `position:"Body" name:"ForSelect"`
	InstanceId      string           `position:"Body" name:"InstanceId"`
	InstanceName    string           `position:"Body" name:"InstanceName"`
	EnablePage      requests.Boolean `position:"Body" name:"EnablePage"`
}

// ListVccGrantRulesResponse is the response struct for api ListVccGrantRules
type ListVccGrantRulesResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListVccGrantRulesRequest creates a request to invoke ListVccGrantRules API
func CreateListVccGrantRulesRequest() (request *ListVccGrantRulesRequest) {
	request = &ListVccGrantRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListVccGrantRules", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVccGrantRulesResponse creates a response to parse from ListVccGrantRules response
func CreateListVccGrantRulesResponse() (response *ListVccGrantRulesResponse) {
	response = &ListVccGrantRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
