package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutors invokes the ehpc.ListExecutors API synchronously
func (client *Client) ListExecutors(request *ListExecutorsRequest) (response *ListExecutorsResponse, err error) {
	response = CreateListExecutorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutorsWithChan invokes the ehpc.ListExecutors API asynchronously
func (client *Client) ListExecutorsWithChan(request *ListExecutorsRequest) (<-chan *ListExecutorsResponse, <-chan error) {
	responseChan := make(chan *ListExecutorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutorsWithCallback invokes the ehpc.ListExecutors API asynchronously
func (client *Client) ListExecutorsWithCallback(request *ListExecutorsRequest, callback func(response *ListExecutorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutorsResponse
		var err error
		defer close(result)
		response, err = client.ListExecutors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutorsRequest is the request struct for api ListExecutors
type ListExecutorsRequest struct {
	*requests.RpcRequest
	PageNumber string              `position:"Query" name:"PageNumber"`
	Filter     ListExecutorsFilter `position:"Query" name:"Filter"  type:"Struct"`
	PageSize   string              `position:"Query" name:"PageSize"`
}

// ListExecutorsFilter is a repeated param struct in ListExecutorsRequest
type ListExecutorsFilter struct {
	TimeCreatedAfter  string    `name:"TimeCreatedAfter"`
	IpAddresses       *[]string `name:"IpAddresses" type:"Repeated"`
	TimeCreatedBefore string    `name:"TimeCreatedBefore"`
	ExecutorIds       *[]string `name:"ExecutorIds" type:"Repeated"`
	JobName           string    `name:"JobName"`
}

// ListExecutorsResponse is the response struct for api ListExecutors
type ListExecutorsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageSize   string     `json:"PageSize" xml:"PageSize"`
	PageNumber string     `json:"PageNumber" xml:"PageNumber"`
	TotalCount string     `json:"TotalCount" xml:"TotalCount"`
	Executors  []Executor `json:"Executors" xml:"Executors"`
}

// CreateListExecutorsRequest creates a request to invoke ListExecutors API
func CreateListExecutorsRequest() (request *ListExecutorsRequest) {
	request = &ListExecutorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2023-07-01", "ListExecutors", "ehs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListExecutorsResponse creates a response to parse from ListExecutors response
func CreateListExecutorsResponse() (response *ListExecutorsResponse) {
	response = &ListExecutorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
