package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobs invokes the ehpc.ListJobs API synchronously
func (client *Client) ListJobs(request *ListJobsRequest) (response *ListJobsResponse, err error) {
	response = CreateListJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobsWithChan invokes the ehpc.ListJobs API asynchronously
func (client *Client) ListJobsWithChan(request *ListJobsRequest) (<-chan *ListJobsResponse, <-chan error) {
	responseChan := make(chan *ListJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobsWithCallback invokes the ehpc.ListJobs API asynchronously
func (client *Client) ListJobsWithCallback(request *ListJobsRequest, callback func(response *ListJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobsResponse
		var err error
		defer close(result)
		response, err = client.ListJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobsRequest is the request struct for api ListJobs
type ListJobsRequest struct {
	*requests.RpcRequest
	PageNumber string         `position:"Query" name:"PageNumber"`
	Filter     ListJobsFilter `position:"Query" name:"Filter"  type:"Struct"`
	PageSize   string         `position:"Query" name:"PageSize"`
	SortBy     ListJobsSortBy `position:"Query" name:"SortBy"  type:"Struct"`
}

// ListJobsFilter is a repeated param struct in ListJobsRequest
type ListJobsFilter struct {
	JobId             string `name:"JobId"`
	TimeCreatedAfter  string `name:"TimeCreatedAfter"`
	TimeCreatedBefore string `name:"TimeCreatedBefore"`
	JobName           string `name:"JobName"`
	Status            string `name:"Status"`
}

// ListJobsSortBy is a repeated param struct in ListJobsRequest
type ListJobsSortBy struct {
	Label string `name:"Label"`
	Order string `name:"Order"`
}

// ListJobsResponse is the response struct for api ListJobs
type ListJobsResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	JobList    []Job  `json:"JobList" xml:"JobList"`
}

// CreateListJobsRequest creates a request to invoke ListJobs API
func CreateListJobsRequest() (request *ListJobsRequest) {
	request = &ListJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2023-07-01", "ListJobs", "ehs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListJobsResponse creates a response to parse from ListJobs response
func CreateListJobsResponse() (response *ListJobsResponse) {
	response = &ListJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
