package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateILMPolicy invokes the elasticsearch.CreateILMPolicy API synchronously
func (client *Client) CreateILMPolicy(request *CreateILMPolicyRequest) (response *CreateILMPolicyResponse, err error) {
	response = CreateCreateILMPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateILMPolicyWithChan invokes the elasticsearch.CreateILMPolicy API asynchronously
func (client *Client) CreateILMPolicyWithChan(request *CreateILMPolicyRequest) (<-chan *CreateILMPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateILMPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateILMPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateILMPolicyWithCallback invokes the elasticsearch.CreateILMPolicy API asynchronously
func (client *Client) CreateILMPolicyWithCallback(request *CreateILMPolicyRequest, callback func(response *CreateILMPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateILMPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateILMPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateILMPolicyRequest is the request struct for api CreateILMPolicy
type CreateILMPolicyRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
}

// CreateILMPolicyResponse is the response struct for api CreateILMPolicy
type CreateILMPolicyResponse struct {
	*responses.BaseResponse
	Result    string `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateILMPolicyRequest creates a request to invoke CreateILMPolicy API
func CreateCreateILMPolicyRequest() (request *CreateILMPolicyRequest) {
	request = &CreateILMPolicyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CreateILMPolicy", "/openapi/instances/[InstanceId]/ilm-policies", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateILMPolicyResponse creates a response to parse from CreateILMPolicy response
func CreateCreateILMPolicyResponse() (response *CreateILMPolicyResponse) {
	response = &CreateILMPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
