package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLogstash invokes the elasticsearch.CreateLogstash API synchronously
func (client *Client) CreateLogstash(request *CreateLogstashRequest) (response *CreateLogstashResponse, err error) {
	response = CreateCreateLogstashResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLogstashWithChan invokes the elasticsearch.CreateLogstash API asynchronously
func (client *Client) CreateLogstashWithChan(request *CreateLogstashRequest) (<-chan *CreateLogstashResponse, <-chan error) {
	responseChan := make(chan *CreateLogstashResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLogstash(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLogstashWithCallback invokes the elasticsearch.CreateLogstash API asynchronously
func (client *Client) CreateLogstashWithCallback(request *CreateLogstashRequest, callback func(response *CreateLogstashResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLogstashResponse
		var err error
		defer close(result)
		response, err = client.CreateLogstash(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLogstashRequest is the request struct for api CreateLogstash
type CreateLogstashRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// CreateLogstashResponse is the response struct for api CreateLogstash
type CreateLogstashResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Result    ResultInCreateLogstash `json:"Result" xml:"Result"`
}

// CreateCreateLogstashRequest creates a request to invoke CreateLogstash API
func CreateCreateLogstashRequest() (request *CreateLogstashRequest) {
	request = &CreateLogstashRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CreateLogstash", "/openapi/logstashes", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLogstashResponse creates a response to parse from CreateLogstash response
func CreateCreateLogstashResponse() (response *CreateLogstashResponse) {
	response = &CreateLogstashResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
