package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableKibanaPvlNetwork invokes the elasticsearch.DisableKibanaPvlNetwork API synchronously
func (client *Client) DisableKibanaPvlNetwork(request *DisableKibanaPvlNetworkRequest) (response *DisableKibanaPvlNetworkResponse, err error) {
	response = CreateDisableKibanaPvlNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// DisableKibanaPvlNetworkWithChan invokes the elasticsearch.DisableKibanaPvlNetwork API asynchronously
func (client *Client) DisableKibanaPvlNetworkWithChan(request *DisableKibanaPvlNetworkRequest) (<-chan *DisableKibanaPvlNetworkResponse, <-chan error) {
	responseChan := make(chan *DisableKibanaPvlNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableKibanaPvlNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableKibanaPvlNetworkWithCallback invokes the elasticsearch.DisableKibanaPvlNetwork API asynchronously
func (client *Client) DisableKibanaPvlNetworkWithCallback(request *DisableKibanaPvlNetworkRequest, callback func(response *DisableKibanaPvlNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableKibanaPvlNetworkResponse
		var err error
		defer close(result)
		response, err = client.DisableKibanaPvlNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableKibanaPvlNetworkRequest is the request struct for api DisableKibanaPvlNetwork
type DisableKibanaPvlNetworkRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DisableKibanaPvlNetworkResponse is the response struct for api DisableKibanaPvlNetwork
type DisableKibanaPvlNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateDisableKibanaPvlNetworkRequest creates a request to invoke DisableKibanaPvlNetwork API
func CreateDisableKibanaPvlNetworkRequest() (request *DisableKibanaPvlNetworkRequest) {
	request = &DisableKibanaPvlNetworkRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DisableKibanaPvlNetwork", "/openapi/instances/[InstanceId]/actions/disable-kibana-private", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableKibanaPvlNetworkResponse creates a response to parse from DisableKibanaPvlNetwork response
func CreateDisableKibanaPvlNetworkResponse() (response *DisableKibanaPvlNetworkResponse) {
	response = &DisableKibanaPvlNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
