package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterV2 invokes the emr.DescribeClusterV2 API synchronously
func (client *Client) DescribeClusterV2(request *DescribeClusterV2Request) (response *DescribeClusterV2Response, err error) {
	response = CreateDescribeClusterV2Response()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterV2WithChan invokes the emr.DescribeClusterV2 API asynchronously
func (client *Client) DescribeClusterV2WithChan(request *DescribeClusterV2Request) (<-chan *DescribeClusterV2Response, <-chan error) {
	responseChan := make(chan *DescribeClusterV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterV2WithCallback invokes the emr.DescribeClusterV2 API asynchronously
func (client *Client) DescribeClusterV2WithCallback(request *DescribeClusterV2Request, callback func(response *DescribeClusterV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterV2Response
		var err error
		defer close(result)
		response, err = client.DescribeClusterV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterV2Request is the request struct for api DescribeClusterV2
type DescribeClusterV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeClusterV2Response is the response struct for api DescribeClusterV2
type DescribeClusterV2Response struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	ClusterInfo ClusterInfo `json:"ClusterInfo" xml:"ClusterInfo"`
}

// CreateDescribeClusterV2Request creates a request to invoke DescribeClusterV2 API
func CreateDescribeClusterV2Request() (request *DescribeClusterV2Request) {
	request = &DescribeClusterV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterV2Response creates a response to parse from DescribeClusterV2 response
func CreateDescribeClusterV2Response() (response *DescribeClusterV2Response) {
	response = &DescribeClusterV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
