package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunScalingActionV2 invokes the emr.RunScalingActionV2 API synchronously
func (client *Client) RunScalingActionV2(request *RunScalingActionV2Request) (response *RunScalingActionV2Response, err error) {
	response = CreateRunScalingActionV2Response()
	err = client.DoAction(request, response)
	return
}

// RunScalingActionV2WithChan invokes the emr.RunScalingActionV2 API asynchronously
func (client *Client) RunScalingActionV2WithChan(request *RunScalingActionV2Request) (<-chan *RunScalingActionV2Response, <-chan error) {
	responseChan := make(chan *RunScalingActionV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunScalingActionV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunScalingActionV2WithCallback invokes the emr.RunScalingActionV2 API asynchronously
func (client *Client) RunScalingActionV2WithCallback(request *RunScalingActionV2Request, callback func(response *RunScalingActionV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunScalingActionV2Response
		var err error
		defer close(result)
		response, err = client.RunScalingActionV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunScalingActionV2Request is the request struct for api RunScalingActionV2
type RunScalingActionV2Request struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScalingActionType string           `position:"Query" name:"ScalingActionType"`
	ScalingGroupBizId string           `position:"Query" name:"ScalingGroupBizId"`
	ResourceGroupId   string           `position:"Query" name:"ResourceGroupId"`
	ActionParam       string           `position:"Query" name:"ActionParam"`
}

// RunScalingActionV2Response is the response struct for api RunScalingActionV2
type RunScalingActionV2Response struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateRunScalingActionV2Request creates a request to invoke RunScalingActionV2 API
func CreateRunScalingActionV2Request() (request *RunScalingActionV2Request) {
	request = &RunScalingActionV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RunScalingActionV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRunScalingActionV2Response creates a response to parse from RunScalingActionV2 response
func CreateRunScalingActionV2Response() (response *RunScalingActionV2Response) {
	response = &RunScalingActionV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
