package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClassicNetwork invokes the ens.CreateClassicNetwork API synchronously
func (client *Client) CreateClassicNetwork(request *CreateClassicNetworkRequest) (response *CreateClassicNetworkResponse, err error) {
	response = CreateCreateClassicNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClassicNetworkWithChan invokes the ens.CreateClassicNetwork API asynchronously
func (client *Client) CreateClassicNetworkWithChan(request *CreateClassicNetworkRequest) (<-chan *CreateClassicNetworkResponse, <-chan error) {
	responseChan := make(chan *CreateClassicNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClassicNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClassicNetworkWithCallback invokes the ens.CreateClassicNetwork API asynchronously
func (client *Client) CreateClassicNetworkWithCallback(request *CreateClassicNetworkRequest, callback func(response *CreateClassicNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClassicNetworkResponse
		var err error
		defer close(result)
		response, err = client.CreateClassicNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClassicNetworkRequest is the request struct for api CreateClassicNetwork
type CreateClassicNetworkRequest struct {
	*requests.RpcRequest
	Description string `position:"Query" name:"Description"`
	NetworkType string `position:"Query" name:"NetworkType"`
	EnsRegionId string `position:"Query" name:"EnsRegionId"`
	NetworkName string `position:"Query" name:"NetworkName"`
	CidrBlock   string `position:"Query" name:"CidrBlock"`
}

// CreateClassicNetworkResponse is the response struct for api CreateClassicNetwork
type CreateClassicNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	NetworkId string `json:"NetworkId" xml:"NetworkId"`
}

// CreateCreateClassicNetworkRequest creates a request to invoke CreateClassicNetwork API
func CreateCreateClassicNetworkRequest() (request *CreateClassicNetworkRequest) {
	request = &CreateClassicNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateClassicNetwork", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateClassicNetworkResponse creates a response to parse from CreateClassicNetwork response
func CreateCreateClassicNetworkResponse() (response *CreateClassicNetworkResponse) {
	response = &CreateClassicNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
