package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsSaleControlAvailableResource invokes the ens.DescribeEnsSaleControlAvailableResource API synchronously
func (client *Client) DescribeEnsSaleControlAvailableResource(request *DescribeEnsSaleControlAvailableResourceRequest) (response *DescribeEnsSaleControlAvailableResourceResponse, err error) {
	response = CreateDescribeEnsSaleControlAvailableResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsSaleControlAvailableResourceWithChan invokes the ens.DescribeEnsSaleControlAvailableResource API asynchronously
func (client *Client) DescribeEnsSaleControlAvailableResourceWithChan(request *DescribeEnsSaleControlAvailableResourceRequest) (<-chan *DescribeEnsSaleControlAvailableResourceResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsSaleControlAvailableResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsSaleControlAvailableResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsSaleControlAvailableResourceWithCallback invokes the ens.DescribeEnsSaleControlAvailableResource API asynchronously
func (client *Client) DescribeEnsSaleControlAvailableResourceWithCallback(request *DescribeEnsSaleControlAvailableResourceRequest, callback func(response *DescribeEnsSaleControlAvailableResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsSaleControlAvailableResourceResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsSaleControlAvailableResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsSaleControlAvailableResourceRequest is the request struct for api DescribeEnsSaleControlAvailableResource
type DescribeEnsSaleControlAvailableResourceRequest struct {
	*requests.RpcRequest
	CustomAccount string `position:"Query" name:"CustomAccount"`
	CommodityCode string `position:"Query" name:"CommodityCode"`
	OrderType     string `position:"Query" name:"OrderType"`
}

// DescribeEnsSaleControlAvailableResourceResponse is the response struct for api DescribeEnsSaleControlAvailableResource
type DescribeEnsSaleControlAvailableResourceResponse struct {
	*responses.BaseResponse
}

// CreateDescribeEnsSaleControlAvailableResourceRequest creates a request to invoke DescribeEnsSaleControlAvailableResource API
func CreateDescribeEnsSaleControlAvailableResourceRequest() (request *DescribeEnsSaleControlAvailableResourceRequest) {
	request = &DescribeEnsSaleControlAvailableResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsSaleControlAvailableResource", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsSaleControlAvailableResourceResponse creates a response to parse from DescribeEnsSaleControlAvailableResource response
func CreateDescribeEnsSaleControlAvailableResourceResponse() (response *DescribeEnsSaleControlAvailableResourceResponse) {
	response = &DescribeEnsSaleControlAvailableResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
