package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEciScalingConfiguration invokes the ess.DeleteEciScalingConfiguration API synchronously
func (client *Client) DeleteEciScalingConfiguration(request *DeleteEciScalingConfigurationRequest) (response *DeleteEciScalingConfigurationResponse, err error) {
	response = CreateDeleteEciScalingConfigurationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEciScalingConfigurationWithChan invokes the ess.DeleteEciScalingConfiguration API asynchronously
func (client *Client) DeleteEciScalingConfigurationWithChan(request *DeleteEciScalingConfigurationRequest) (<-chan *DeleteEciScalingConfigurationResponse, <-chan error) {
	responseChan := make(chan *DeleteEciScalingConfigurationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEciScalingConfiguration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEciScalingConfigurationWithCallback invokes the ess.DeleteEciScalingConfiguration API asynchronously
func (client *Client) DeleteEciScalingConfigurationWithCallback(request *DeleteEciScalingConfigurationRequest, callback func(response *DeleteEciScalingConfigurationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEciScalingConfigurationResponse
		var err error
		defer close(result)
		response, err = client.DeleteEciScalingConfiguration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEciScalingConfigurationRequest is the request struct for api DeleteEciScalingConfiguration
type DeleteEciScalingConfigurationRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	ScalingConfigurationId string           `position:"Query" name:"ScalingConfigurationId"`
}

// DeleteEciScalingConfigurationResponse is the response struct for api DeleteEciScalingConfiguration
type DeleteEciScalingConfigurationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteEciScalingConfigurationRequest creates a request to invoke DeleteEciScalingConfiguration API
func CreateDeleteEciScalingConfigurationRequest() (request *DeleteEciScalingConfigurationRequest) {
	request = &DeleteEciScalingConfigurationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DeleteEciScalingConfiguration", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteEciScalingConfigurationResponse creates a response to parse from DeleteEciScalingConfiguration response
func CreateDeleteEciScalingConfigurationResponse() (response *DeleteEciScalingConfigurationResponse) {
	response = &DeleteEciScalingConfigurationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
