package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventSource invokes the eventbridge.DeleteEventSource API synchronously
func (client *Client) DeleteEventSource(request *DeleteEventSourceRequest) (response *DeleteEventSourceResponse, err error) {
	response = CreateDeleteEventSourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventSourceWithChan invokes the eventbridge.DeleteEventSource API asynchronously
func (client *Client) DeleteEventSourceWithChan(request *DeleteEventSourceRequest) (<-chan *DeleteEventSourceResponse, <-chan error) {
	responseChan := make(chan *DeleteEventSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventSourceWithCallback invokes the eventbridge.DeleteEventSource API asynchronously
func (client *Client) DeleteEventSourceWithCallback(request *DeleteEventSourceRequest, callback func(response *DeleteEventSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventSourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventSourceRequest is the request struct for api DeleteEventSource
type DeleteEventSourceRequest struct {
	*requests.RpcRequest
	EventSourceName string `position:"Body" name:"EventSourceName"`
}

// DeleteEventSourceResponse is the response struct for api DeleteEventSource
type DeleteEventSourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEventSourceRequest creates a request to invoke DeleteEventSource API
func CreateDeleteEventSourceRequest() (request *DeleteEventSourceRequest) {
	request = &DeleteEventSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DeleteEventSource", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEventSourceResponse creates a response to parse from DeleteEventSource response
func CreateDeleteEventSourceResponse() (response *DeleteEventSourceResponse) {
	response = &DeleteEventSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
