package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEventTraces invokes the eventbridge.QueryEventTraces API synchronously
func (client *Client) QueryEventTraces(request *QueryEventTracesRequest) (response *QueryEventTracesResponse, err error) {
	response = CreateQueryEventTracesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEventTracesWithChan invokes the eventbridge.QueryEventTraces API asynchronously
func (client *Client) QueryEventTracesWithChan(request *QueryEventTracesRequest) (<-chan *QueryEventTracesResponse, <-chan error) {
	responseChan := make(chan *QueryEventTracesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEventTraces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEventTracesWithCallback invokes the eventbridge.QueryEventTraces API asynchronously
func (client *Client) QueryEventTracesWithCallback(request *QueryEventTracesRequest, callback func(response *QueryEventTracesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEventTracesResponse
		var err error
		defer close(result)
		response, err = client.QueryEventTraces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEventTracesRequest is the request struct for api QueryEventTraces
type QueryEventTracesRequest struct {
	*requests.RpcRequest
	EventId      string `position:"Query" name:"EventId"`
	EventBusName string `position:"Query" name:"EventBusName"`
}

// QueryEventTracesResponse is the response struct for api QueryEventTraces
type QueryEventTracesResponse struct {
	*responses.BaseResponse
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryEventTracesRequest creates a request to invoke QueryEventTraces API
func CreateQueryEventTracesRequest() (request *QueryEventTracesRequest) {
	request = &QueryEventTracesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "QueryEventTraces", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEventTracesResponse creates a response to parse from QueryEventTraces response
func CreateQueryEventTracesResponse() (response *QueryEventTracesResponse) {
	response = &QueryEventTracesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
