package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CalcBMD invokes the imageprocess.CalcBMD API synchronously
func (client *Client) CalcBMD(request *CalcBMDRequest) (response *CalcBMDResponse, err error) {
	response = CreateCalcBMDResponse()
	err = client.DoAction(request, response)
	return
}

// CalcBMDWithChan invokes the imageprocess.CalcBMD API asynchronously
func (client *Client) CalcBMDWithChan(request *CalcBMDRequest) (<-chan *CalcBMDResponse, <-chan error) {
	responseChan := make(chan *CalcBMDResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CalcBMD(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CalcBMDWithCallback invokes the imageprocess.CalcBMD API asynchronously
func (client *Client) CalcBMDWithCallback(request *CalcBMDRequest, callback func(response *CalcBMDResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CalcBMDResponse
		var err error
		defer close(result)
		response, err = client.CalcBMD(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CalcBMDRequest is the request struct for api CalcBMD
type CalcBMDRequest struct {
	*requests.RpcRequest
	OrgName    string            `position:"Body" name:"OrgName"`
	SourceType string            `position:"Body" name:"SourceType"`
	DataFormat string            `position:"Body" name:"DataFormat"`
	URLList    *[]CalcBMDURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId      string            `position:"Body" name:"OrgId"`
	Async      requests.Boolean  `position:"Body" name:"Async"`
}

// CalcBMDURLList is a repeated param struct in CalcBMDRequest
type CalcBMDURLList struct {
	URL string `name:"URL"`
}

// CalcBMDResponse is the response struct for api CalcBMD
type CalcBMDResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCalcBMDRequest creates a request to invoke CalcBMD API
func CreateCalcBMDRequest() (request *CalcBMDRequest) {
	request = &CalcBMDRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "CalcBMD", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCalcBMDResponse creates a response to parse from CalcBMD response
func CreateCalcBMDResponse() (response *CalcBMDResponse) {
	response = &CalcBMDResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
