package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveClientIdFromOIDCProvider invokes the ims.RemoveClientIdFromOIDCProvider API synchronously
func (client *Client) RemoveClientIdFromOIDCProvider(request *RemoveClientIdFromOIDCProviderRequest) (response *RemoveClientIdFromOIDCProviderResponse, err error) {
	response = CreateRemoveClientIdFromOIDCProviderResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveClientIdFromOIDCProviderWithChan invokes the ims.RemoveClientIdFromOIDCProvider API asynchronously
func (client *Client) RemoveClientIdFromOIDCProviderWithChan(request *RemoveClientIdFromOIDCProviderRequest) (<-chan *RemoveClientIdFromOIDCProviderResponse, <-chan error) {
	responseChan := make(chan *RemoveClientIdFromOIDCProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveClientIdFromOIDCProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveClientIdFromOIDCProviderWithCallback invokes the ims.RemoveClientIdFromOIDCProvider API asynchronously
func (client *Client) RemoveClientIdFromOIDCProviderWithCallback(request *RemoveClientIdFromOIDCProviderRequest, callback func(response *RemoveClientIdFromOIDCProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveClientIdFromOIDCProviderResponse
		var err error
		defer close(result)
		response, err = client.RemoveClientIdFromOIDCProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveClientIdFromOIDCProviderRequest is the request struct for api RemoveClientIdFromOIDCProvider
type RemoveClientIdFromOIDCProviderRequest struct {
	*requests.RpcRequest
	ClientId         string `position:"Query" name:"ClientId"`
	AkProxySuffix    string `position:"Query" name:"AkProxySuffix"`
	OIDCProviderName string `position:"Query" name:"OIDCProviderName"`
}

// RemoveClientIdFromOIDCProviderResponse is the response struct for api RemoveClientIdFromOIDCProvider
type RemoveClientIdFromOIDCProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	OIDCProvider OIDCProvider `json:"OIDCProvider" xml:"OIDCProvider"`
}

// CreateRemoveClientIdFromOIDCProviderRequest creates a request to invoke RemoveClientIdFromOIDCProvider API
func CreateRemoveClientIdFromOIDCProviderRequest() (request *RemoveClientIdFromOIDCProviderRequest) {
	request = &RemoveClientIdFromOIDCProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "RemoveClientIdFromOIDCProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveClientIdFromOIDCProviderResponse creates a response to parse from RemoveClientIdFromOIDCProvider response
func CreateRemoveClientIdFromOIDCProviderResponse() (response *RemoveClientIdFromOIDCProviderResponse) {
	response = &RemoveClientIdFromOIDCProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
