package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDeviceTunnelShare invokes the iot.EnableDeviceTunnelShare API synchronously
func (client *Client) EnableDeviceTunnelShare(request *EnableDeviceTunnelShareRequest) (response *EnableDeviceTunnelShareResponse, err error) {
	response = CreateEnableDeviceTunnelShareResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDeviceTunnelShareWithChan invokes the iot.EnableDeviceTunnelShare API asynchronously
func (client *Client) EnableDeviceTunnelShareWithChan(request *EnableDeviceTunnelShareRequest) (<-chan *EnableDeviceTunnelShareResponse, <-chan error) {
	responseChan := make(chan *EnableDeviceTunnelShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDeviceTunnelShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDeviceTunnelShareWithCallback invokes the iot.EnableDeviceTunnelShare API asynchronously
func (client *Client) EnableDeviceTunnelShareWithCallback(request *EnableDeviceTunnelShareRequest, callback func(response *EnableDeviceTunnelShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDeviceTunnelShareResponse
		var err error
		defer close(result)
		response, err = client.EnableDeviceTunnelShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDeviceTunnelShareRequest is the request struct for api EnableDeviceTunnelShare
type EnableDeviceTunnelShareRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// EnableDeviceTunnelShareResponse is the response struct for api EnableDeviceTunnelShare
type EnableDeviceTunnelShareResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
}

// CreateEnableDeviceTunnelShareRequest creates a request to invoke EnableDeviceTunnelShare API
func CreateEnableDeviceTunnelShareRequest() (request *EnableDeviceTunnelShareRequest) {
	request = &EnableDeviceTunnelShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "EnableDeviceTunnelShare", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableDeviceTunnelShareResponse creates a response to parse from EnableDeviceTunnelShare response
func CreateEnableDeviceTunnelShareResponse() (response *EnableDeviceTunnelShareResponse) {
	response = &EnableDeviceTunnelShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
