package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDevicesHotStorageData invokes the iot.QueryDevicesHotStorageData API synchronously
func (client *Client) QueryDevicesHotStorageData(request *QueryDevicesHotStorageDataRequest) (response *QueryDevicesHotStorageDataResponse, err error) {
	response = CreateQueryDevicesHotStorageDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDevicesHotStorageDataWithChan invokes the iot.QueryDevicesHotStorageData API asynchronously
func (client *Client) QueryDevicesHotStorageDataWithChan(request *QueryDevicesHotStorageDataRequest) (<-chan *QueryDevicesHotStorageDataResponse, <-chan error) {
	responseChan := make(chan *QueryDevicesHotStorageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDevicesHotStorageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDevicesHotStorageDataWithCallback invokes the iot.QueryDevicesHotStorageData API asynchronously
func (client *Client) QueryDevicesHotStorageDataWithCallback(request *QueryDevicesHotStorageDataRequest, callback func(response *QueryDevicesHotStorageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDevicesHotStorageDataResponse
		var err error
		defer close(result)
		response, err = client.QueryDevicesHotStorageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDevicesHotStorageDataRequest is the request struct for api QueryDevicesHotStorageData
type QueryDevicesHotStorageDataRequest struct {
	*requests.RpcRequest
	NextPageToken     string           `position:"Query" name:"NextPageToken"`
	RealTenantId      string           `position:"Query" name:"RealTenantId"`
	StartTime         requests.Integer `position:"Query" name:"StartTime"`
	RealTripartiteKey string           `position:"Query" name:"RealTripartiteKey"`
	IotId             string           `position:"Query" name:"IotId"`
	IotInstanceId     string           `position:"Query" name:"IotInstanceId"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	Identifier        string           `position:"Query" name:"Identifier"`
	UserTopic         string           `position:"Query" name:"UserTopic"`
	EndTime           requests.Integer `position:"Query" name:"EndTime"`
	ProductKey        string           `position:"Query" name:"ProductKey"`
	Asc               requests.Integer `position:"Query" name:"Asc"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
	DeviceName        string           `position:"Query" name:"DeviceName"`
}

// QueryDevicesHotStorageDataResponse is the response struct for api QueryDevicesHotStorageData
type QueryDevicesHotStorageDataResponse struct {
	*responses.BaseResponse
	RequestId    string                           `json:"RequestId" xml:"RequestId"`
	Success      bool                             `json:"Success" xml:"Success"`
	Code         string                           `json:"Code" xml:"Code"`
	ErrorMessage string                           `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDevicesHotStorageData `json:"Data" xml:"Data"`
}

// CreateQueryDevicesHotStorageDataRequest creates a request to invoke QueryDevicesHotStorageData API
func CreateQueryDevicesHotStorageDataRequest() (request *QueryDevicesHotStorageDataRequest) {
	request = &QueryDevicesHotStorageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDevicesHotStorageData", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDevicesHotStorageDataResponse creates a response to parse from QueryDevicesHotStorageData response
func CreateQueryDevicesHotStorageDataResponse() (response *QueryDevicesHotStorageDataResponse) {
	response = &QueryDevicesHotStorageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
