package iqs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryHotels invokes the iqs.QueryHotels API synchronously
func (client *Client) QueryHotels(request *QueryHotelsRequest) (response *QueryHotelsResponse, err error) {
	response = CreateQueryHotelsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryHotelsWithChan invokes the iqs.QueryHotels API asynchronously
func (client *Client) QueryHotelsWithChan(request *QueryHotelsRequest) (<-chan *QueryHotelsResponse, <-chan error) {
	responseChan := make(chan *QueryHotelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryHotels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryHotelsWithCallback invokes the iqs.QueryHotels API asynchronously
func (client *Client) QueryHotelsWithCallback(request *QueryHotelsRequest, callback func(response *QueryHotelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryHotelsResponse
		var err error
		defer close(result)
		response, err = client.QueryHotels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryHotelsRequest is the request struct for api QueryHotels
type QueryHotelsRequest struct {
	*requests.RoaRequest
}

// QueryHotelsResponse is the response struct for api QueryHotels
type QueryHotelsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"requestId" xml:"requestId"`
	QueryResult QueryResult `json:"queryResult" xml:"queryResult"`
}

// CreateQueryHotelsRequest creates a request to invoke QueryHotels API
func CreateQueryHotelsRequest() (request *QueryHotelsRequest) {
	request = &QueryHotelsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("IQS", "2024-07-12", "QueryHotels", "/amap-function-call-agent/iqs-agent-service/v1/nl/hotels", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryHotelsResponse creates a response to parse from QueryHotels response
func CreateQueryHotelsResponse() (response *QueryHotelsResponse) {
	response = &QueryHotelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
