package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBoxCodeList invokes the itaas.GetBoxCodeList API synchronously
// api document: https://help.aliyun.com/api/itaas/getboxcodelist.html
func (client *Client) GetBoxCodeList(request *GetBoxCodeListRequest) (response *GetBoxCodeListResponse, err error) {
	response = CreateGetBoxCodeListResponse()
	err = client.DoAction(request, response)
	return
}

// GetBoxCodeListWithChan invokes the itaas.GetBoxCodeList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getboxcodelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBoxCodeListWithChan(request *GetBoxCodeListRequest) (<-chan *GetBoxCodeListResponse, <-chan error) {
	responseChan := make(chan *GetBoxCodeListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBoxCodeList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBoxCodeListWithCallback invokes the itaas.GetBoxCodeList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getboxcodelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBoxCodeListWithCallback(request *GetBoxCodeListRequest, callback func(response *GetBoxCodeListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBoxCodeListResponse
		var err error
		defer close(result)
		response, err = client.GetBoxCodeList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBoxCodeListRequest is the request struct for api GetBoxCodeList
type GetBoxCodeListRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// GetBoxCodeListResponse is the response struct for api GetBoxCodeList
type GetBoxCodeListResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	ErrorCode int                       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                    `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                      `json:"Success" xml:"Success"`
	Data      DataInGetBoxCodeList      `json:"Data" xml:"Data"`
	ErrorList ErrorListInGetBoxCodeList `json:"ErrorList" xml:"ErrorList"`
}

// CreateGetBoxCodeListRequest creates a request to invoke GetBoxCodeList API
func CreateGetBoxCodeListRequest() (request *GetBoxCodeListRequest) {
	request = &GetBoxCodeListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "GetBoxCodeList", "itaas", "openAPI")
	return
}

// CreateGetBoxCodeListResponse creates a response to parse from GetBoxCodeList response
func CreateGetBoxCodeListResponse() (response *GetBoxCodeListResponse) {
	response = &GetBoxCodeListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
