package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccessWhitelistEcsList invokes the jarvis.DescribeAccessWhitelistEcsList API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistecslist.html
func (client *Client) DescribeAccessWhitelistEcsList(request *DescribeAccessWhitelistEcsListRequest) (response *DescribeAccessWhitelistEcsListResponse, err error) {
	response = CreateDescribeAccessWhitelistEcsListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccessWhitelistEcsListWithChan invokes the jarvis.DescribeAccessWhitelistEcsList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistecslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessWhitelistEcsListWithChan(request *DescribeAccessWhitelistEcsListRequest) (<-chan *DescribeAccessWhitelistEcsListResponse, <-chan error) {
	responseChan := make(chan *DescribeAccessWhitelistEcsListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccessWhitelistEcsList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccessWhitelistEcsListWithCallback invokes the jarvis.DescribeAccessWhitelistEcsList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeaccesswhitelistecslist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessWhitelistEcsListWithCallback(request *DescribeAccessWhitelistEcsListRequest, callback func(response *DescribeAccessWhitelistEcsListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccessWhitelistEcsListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccessWhitelistEcsList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccessWhitelistEcsListRequest is the request struct for api DescribeAccessWhitelistEcsList
type DescribeAccessWhitelistEcsListRequest struct {
	*requests.RpcRequest
	SourceIp   string `position:"Query" name:"SourceIp"`
	Lang       string `position:"Query" name:"Lang"`
	SourceCode string `position:"Query" name:"SourceCode"`
}

// DescribeAccessWhitelistEcsListResponse is the response struct for api DescribeAccessWhitelistEcsList
type DescribeAccessWhitelistEcsListResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Module     string `json:"module" xml:"module"`
	EcsList    []Ecs  `json:"EcsList" xml:"EcsList"`
}

// CreateDescribeAccessWhitelistEcsListRequest creates a request to invoke DescribeAccessWhitelistEcsList API
func CreateDescribeAccessWhitelistEcsListRequest() (request *DescribeAccessWhitelistEcsListRequest) {
	request = &DescribeAccessWhitelistEcsListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeAccessWhitelistEcsList", "jarvis", "openAPI")
	return
}

// CreateDescribeAccessWhitelistEcsListResponse creates a response to parse from DescribeAccessWhitelistEcsList response
func CreateDescribeAccessWhitelistEcsListResponse() (response *DescribeAccessWhitelistEcsListResponse) {
	response = &DescribeAccessWhitelistEcsListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
