package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFaceUserGroupAndDeviceGroupRelation invokes the linkvisual.UpdateFaceUserGroupAndDeviceGroupRelation API synchronously
func (client *Client) UpdateFaceUserGroupAndDeviceGroupRelation(request *UpdateFaceUserGroupAndDeviceGroupRelationRequest) (response *UpdateFaceUserGroupAndDeviceGroupRelationResponse, err error) {
	response = CreateUpdateFaceUserGroupAndDeviceGroupRelationResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFaceUserGroupAndDeviceGroupRelationWithChan invokes the linkvisual.UpdateFaceUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) UpdateFaceUserGroupAndDeviceGroupRelationWithChan(request *UpdateFaceUserGroupAndDeviceGroupRelationRequest) (<-chan *UpdateFaceUserGroupAndDeviceGroupRelationResponse, <-chan error) {
	responseChan := make(chan *UpdateFaceUserGroupAndDeviceGroupRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFaceUserGroupAndDeviceGroupRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFaceUserGroupAndDeviceGroupRelationWithCallback invokes the linkvisual.UpdateFaceUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) UpdateFaceUserGroupAndDeviceGroupRelationWithCallback(request *UpdateFaceUserGroupAndDeviceGroupRelationRequest, callback func(response *UpdateFaceUserGroupAndDeviceGroupRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFaceUserGroupAndDeviceGroupRelationResponse
		var err error
		defer close(result)
		response, err = client.UpdateFaceUserGroupAndDeviceGroupRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFaceUserGroupAndDeviceGroupRelationRequest is the request struct for api UpdateFaceUserGroupAndDeviceGroupRelation
type UpdateFaceUserGroupAndDeviceGroupRelationRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	ControlId   string `position:"Query" name:"ControlId"`
	Relation    string `position:"Query" name:"Relation"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// UpdateFaceUserGroupAndDeviceGroupRelationResponse is the response struct for api UpdateFaceUserGroupAndDeviceGroupRelation
type UpdateFaceUserGroupAndDeviceGroupRelationResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateUpdateFaceUserGroupAndDeviceGroupRelationRequest creates a request to invoke UpdateFaceUserGroupAndDeviceGroupRelation API
func CreateUpdateFaceUserGroupAndDeviceGroupRelationRequest() (request *UpdateFaceUserGroupAndDeviceGroupRelationRequest) {
	request = &UpdateFaceUserGroupAndDeviceGroupRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "UpdateFaceUserGroupAndDeviceGroupRelation", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateFaceUserGroupAndDeviceGroupRelationResponse creates a response to parse from UpdateFaceUserGroupAndDeviceGroupRelation response
func CreateUpdateFaceUserGroupAndDeviceGroupRelationResponse() (response *UpdateFaceUserGroupAndDeviceGroupRelationResponse) {
	response = &UpdateFaceUserGroupAndDeviceGroupRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
