package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendUnicastCommand invokes the linkwan.SendUnicastCommand API synchronously
func (client *Client) SendUnicastCommand(request *SendUnicastCommandRequest) (response *SendUnicastCommandResponse, err error) {
	response = CreateSendUnicastCommandResponse()
	err = client.DoAction(request, response)
	return
}

// SendUnicastCommandWithChan invokes the linkwan.SendUnicastCommand API asynchronously
func (client *Client) SendUnicastCommandWithChan(request *SendUnicastCommandRequest) (<-chan *SendUnicastCommandResponse, <-chan error) {
	responseChan := make(chan *SendUnicastCommandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendUnicastCommand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendUnicastCommandWithCallback invokes the linkwan.SendUnicastCommand API asynchronously
func (client *Client) SendUnicastCommandWithCallback(request *SendUnicastCommandRequest, callback func(response *SendUnicastCommandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendUnicastCommandResponse
		var err error
		defer close(result)
		response, err = client.SendUnicastCommand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendUnicastCommandRequest is the request struct for api SendUnicastCommand
type SendUnicastCommandRequest struct {
	*requests.RpcRequest
	Confirmed     requests.Boolean `position:"Query" name:"Confirmed"`
	Content       string           `position:"Query" name:"Content"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	MaxRetries    requests.Integer `position:"Query" name:"MaxRetries"`
	DevEui        string           `position:"Query" name:"DevEui"`
	CleanUp       requests.Boolean `position:"Query" name:"CleanUp"`
	FPort         requests.Integer `position:"Query" name:"FPort"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// SendUnicastCommandResponse is the response struct for api SendUnicastCommand
type SendUnicastCommandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSendUnicastCommandRequest creates a request to invoke SendUnicastCommand API
func CreateSendUnicastCommandRequest() (request *SendUnicastCommandRequest) {
	request = &SendUnicastCommandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "SendUnicastCommand", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendUnicastCommandResponse creates a response to parse from SendUnicastCommand response
func CreateSendUnicastCommandResponse() (response *SendUnicastCommandResponse) {
	response = &SendUnicastCommandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
