package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveAIStudio invokes the live.DescribeLiveAIStudio API synchronously
func (client *Client) DescribeLiveAIStudio(request *DescribeLiveAIStudioRequest) (response *DescribeLiveAIStudioResponse, err error) {
	response = CreateDescribeLiveAIStudioResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveAIStudioWithChan invokes the live.DescribeLiveAIStudio API asynchronously
func (client *Client) DescribeLiveAIStudioWithChan(request *DescribeLiveAIStudioRequest) (<-chan *DescribeLiveAIStudioResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveAIStudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveAIStudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveAIStudioWithCallback invokes the live.DescribeLiveAIStudio API asynchronously
func (client *Client) DescribeLiveAIStudioWithCallback(request *DescribeLiveAIStudioRequest, callback func(response *DescribeLiveAIStudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveAIStudioResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveAIStudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveAIStudioRequest is the request struct for api DescribeLiveAIStudio
type DescribeLiveAIStudioRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StudioId   string           `position:"Query" name:"StudioId"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	StudioName string           `position:"Query" name:"StudioName"`
}

// DescribeLiveAIStudioResponse is the response struct for api DescribeLiveAIStudio
type DescribeLiveAIStudioResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Total         int           `json:"Total" xml:"Total"`
	PageNumber    int           `json:"PageNumber" xml:"PageNumber"`
	PageSize      int           `json:"PageSize" xml:"PageSize"`
	StudioConfigs StudioConfigs `json:"StudioConfigs" xml:"StudioConfigs"`
}

// CreateDescribeLiveAIStudioRequest creates a request to invoke DescribeLiveAIStudio API
func CreateDescribeLiveAIStudioRequest() (request *DescribeLiveAIStudioRequest) {
	request = &DescribeLiveAIStudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveAIStudio", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveAIStudioResponse creates a response to parse from DescribeLiveAIStudio response
func CreateDescribeLiveAIStudioResponse() (response *DescribeLiveAIStudioResponse) {
	response = &DescribeLiveAIStudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
