package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveAISubtitle invokes the live.DescribeLiveAISubtitle API synchronously
func (client *Client) DescribeLiveAISubtitle(request *DescribeLiveAISubtitleRequest) (response *DescribeLiveAISubtitleResponse, err error) {
	response = CreateDescribeLiveAISubtitleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveAISubtitleWithChan invokes the live.DescribeLiveAISubtitle API asynchronously
func (client *Client) DescribeLiveAISubtitleWithChan(request *DescribeLiveAISubtitleRequest) (<-chan *DescribeLiveAISubtitleResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveAISubtitleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveAISubtitle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveAISubtitleWithCallback invokes the live.DescribeLiveAISubtitle API asynchronously
func (client *Client) DescribeLiveAISubtitleWithCallback(request *DescribeLiveAISubtitleRequest, callback func(response *DescribeLiveAISubtitleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveAISubtitleResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveAISubtitle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveAISubtitleRequest is the request struct for api DescribeLiveAISubtitle
type DescribeLiveAISubtitleRequest struct {
	*requests.RpcRequest
	SubtitleName string           `position:"Query" name:"SubtitleName"`
	PageNumber   string           `position:"Query" name:"PageNumber"`
	PageSize     string           `position:"Query" name:"PageSize"`
	IsDefault    requests.Boolean `position:"Query" name:"IsDefault"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	SubtitleId   string           `position:"Query" name:"SubtitleId"`
}

// DescribeLiveAISubtitleResponse is the response struct for api DescribeLiveAISubtitle
type DescribeLiveAISubtitleResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	SubtitleConfigs SubtitleConfigs `json:"SubtitleConfigs" xml:"SubtitleConfigs"`
}

// CreateDescribeLiveAISubtitleRequest creates a request to invoke DescribeLiveAISubtitle API
func CreateDescribeLiveAISubtitleRequest() (request *DescribeLiveAISubtitleRequest) {
	request = &DescribeLiveAISubtitleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveAISubtitle", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveAISubtitleResponse creates a response to parse from DescribeLiveAISubtitle response
func CreateDescribeLiveAISubtitleResponse() (response *DescribeLiveAISubtitleResponse) {
	response = &DescribeLiveAISubtitleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
