package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamsNotifyRecords invokes the live.DescribeLiveStreamsNotifyRecords API synchronously
func (client *Client) DescribeLiveStreamsNotifyRecords(request *DescribeLiveStreamsNotifyRecordsRequest) (response *DescribeLiveStreamsNotifyRecordsResponse, err error) {
	response = CreateDescribeLiveStreamsNotifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamsNotifyRecordsWithChan invokes the live.DescribeLiveStreamsNotifyRecords API asynchronously
func (client *Client) DescribeLiveStreamsNotifyRecordsWithChan(request *DescribeLiveStreamsNotifyRecordsRequest) (<-chan *DescribeLiveStreamsNotifyRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamsNotifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamsNotifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamsNotifyRecordsWithCallback invokes the live.DescribeLiveStreamsNotifyRecords API asynchronously
func (client *Client) DescribeLiveStreamsNotifyRecordsWithCallback(request *DescribeLiveStreamsNotifyRecordsRequest, callback func(response *DescribeLiveStreamsNotifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamsNotifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamsNotifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamsNotifyRecordsRequest is the request struct for api DescribeLiveStreamsNotifyRecords
type DescribeLiveStreamsNotifyRecordsRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	AppName    string           `position:"Query" name:"AppName"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeLiveStreamsNotifyRecordsResponse is the response struct for api DescribeLiveStreamsNotifyRecords
type DescribeLiveStreamsNotifyRecordsResponse struct {
	*responses.BaseResponse
	PageNum           int               `json:"PageNum" xml:"PageNum"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	TotalNum          int               `json:"TotalNum" xml:"TotalNum"`
	TotalPage         int               `json:"TotalPage" xml:"TotalPage"`
	NotifyRecordsInfo NotifyRecordsInfo `json:"NotifyRecordsInfo" xml:"NotifyRecordsInfo"`
}

// CreateDescribeLiveStreamsNotifyRecordsRequest creates a request to invoke DescribeLiveStreamsNotifyRecords API
func CreateDescribeLiveStreamsNotifyRecordsRequest() (request *DescribeLiveStreamsNotifyRecordsRequest) {
	request = &DescribeLiveStreamsNotifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveStreamsNotifyRecords", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveStreamsNotifyRecordsResponse creates a response to parse from DescribeLiveStreamsNotifyRecords response
func CreateDescribeLiveStreamsNotifyRecordsResponse() (response *DescribeLiveStreamsNotifyRecordsResponse) {
	response = &DescribeLiveStreamsNotifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
