package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveAIProduceRules invokes the live.UpdateLiveAIProduceRules API synchronously
func (client *Client) UpdateLiveAIProduceRules(request *UpdateLiveAIProduceRulesRequest) (response *UpdateLiveAIProduceRulesResponse, err error) {
	response = CreateUpdateLiveAIProduceRulesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveAIProduceRulesWithChan invokes the live.UpdateLiveAIProduceRules API asynchronously
func (client *Client) UpdateLiveAIProduceRulesWithChan(request *UpdateLiveAIProduceRulesRequest) (<-chan *UpdateLiveAIProduceRulesResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveAIProduceRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveAIProduceRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveAIProduceRulesWithCallback invokes the live.UpdateLiveAIProduceRules API asynchronously
func (client *Client) UpdateLiveAIProduceRulesWithCallback(request *UpdateLiveAIProduceRulesRequest, callback func(response *UpdateLiveAIProduceRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveAIProduceRulesResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveAIProduceRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveAIProduceRulesRequest is the request struct for api UpdateLiveAIProduceRules
type UpdateLiveAIProduceRulesRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	Suffix       string           `position:"Query" name:"Suffix"`
	SubtitleName string           `position:"Query" name:"SubtitleName"`
	RulesId      string           `position:"Query" name:"RulesId"`
	App          string           `position:"Query" name:"App"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	IsLazy       requests.Boolean `position:"Query" name:"IsLazy"`
	StudioName   string           `position:"Query" name:"StudioName"`
	LiveTemplate string           `position:"Query" name:"LiveTemplate"`
	Domain       string           `position:"Query" name:"Domain"`
	IsOrigin     requests.Boolean `position:"Query" name:"IsOrigin"`
	SubtitleId   string           `position:"Query" name:"SubtitleId"`
}

// UpdateLiveAIProduceRulesResponse is the response struct for api UpdateLiveAIProduceRules
type UpdateLiveAIProduceRulesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveAIProduceRulesRequest creates a request to invoke UpdateLiveAIProduceRules API
func CreateUpdateLiveAIProduceRulesRequest() (request *UpdateLiveAIProduceRulesRequest) {
	request = &UpdateLiveAIProduceRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveAIProduceRules", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveAIProduceRulesResponse creates a response to parse from UpdateLiveAIProduceRules response
func CreateUpdateLiveAIProduceRulesResponse() (response *UpdateLiveAIProduceRulesResponse) {
	response = &UpdateLiveAIProduceRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
