package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadMPCoSPhaseTextInfoByDevice invokes the ltl.UploadMPCoSPhaseTextInfoByDevice API synchronously
func (client *Client) UploadMPCoSPhaseTextInfoByDevice(request *UploadMPCoSPhaseTextInfoByDeviceRequest) (response *UploadMPCoSPhaseTextInfoByDeviceResponse, err error) {
	response = CreateUploadMPCoSPhaseTextInfoByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UploadMPCoSPhaseTextInfoByDeviceWithChan invokes the ltl.UploadMPCoSPhaseTextInfoByDevice API asynchronously
func (client *Client) UploadMPCoSPhaseTextInfoByDeviceWithChan(request *UploadMPCoSPhaseTextInfoByDeviceRequest) (<-chan *UploadMPCoSPhaseTextInfoByDeviceResponse, <-chan error) {
	responseChan := make(chan *UploadMPCoSPhaseTextInfoByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadMPCoSPhaseTextInfoByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadMPCoSPhaseTextInfoByDeviceWithCallback invokes the ltl.UploadMPCoSPhaseTextInfoByDevice API asynchronously
func (client *Client) UploadMPCoSPhaseTextInfoByDeviceWithCallback(request *UploadMPCoSPhaseTextInfoByDeviceRequest, callback func(response *UploadMPCoSPhaseTextInfoByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadMPCoSPhaseTextInfoByDeviceResponse
		var err error
		defer close(result)
		response, err = client.UploadMPCoSPhaseTextInfoByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadMPCoSPhaseTextInfoByDeviceRequest is the request struct for api UploadMPCoSPhaseTextInfoByDevice
type UploadMPCoSPhaseTextInfoByDeviceRequest struct {
	*requests.RpcRequest
	IotSignature         string                 `position:"Query" name:"IotSignature"`
	IotAuthType          string                 `position:"Query" name:"IotAuthType"`
	IotIdSource          string                 `position:"Query" name:"IotIdSource"`
	PhaseData            string                 `position:"Query" name:"PhaseData"`
	PhaseId              string                 `position:"Query" name:"PhaseId"`
	ApiVersion           string                 `position:"Query" name:"ApiVersion"`
	BizChainId           string                 `position:"Query" name:"BizChainId"`
	DataKey              string                 `position:"Query" name:"DataKey"`
	DataSeq              string                 `position:"Query" name:"DataSeq"`
	IotId                string                 `position:"Query" name:"IotId"`
	PhaseGroupId         string                 `position:"Query" name:"PhaseGroupId"`
	IotDataDigest        string                 `position:"Query" name:"IotDataDigest"`
	IotIdServiceProvider string                 `position:"Query" name:"IotIdServiceProvider"`
	RelatedDataList      map[string]interface{} `position:"Query" name:"RelatedDataList"`
}

// UploadMPCoSPhaseTextInfoByDeviceResponse is the response struct for api UploadMPCoSPhaseTextInfoByDevice
type UploadMPCoSPhaseTextInfoByDeviceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUploadMPCoSPhaseTextInfoByDeviceRequest creates a request to invoke UploadMPCoSPhaseTextInfoByDevice API
func CreateUploadMPCoSPhaseTextInfoByDeviceRequest() (request *UploadMPCoSPhaseTextInfoByDeviceRequest) {
	request = &UploadMPCoSPhaseTextInfoByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "UploadMPCoSPhaseTextInfoByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadMPCoSPhaseTextInfoByDeviceResponse creates a response to parse from UploadMPCoSPhaseTextInfoByDevice response
func CreateUploadMPCoSPhaseTextInfoByDeviceResponse() (response *UploadMPCoSPhaseTextInfoByDeviceResponse) {
	response = &UploadMPCoSPhaseTextInfoByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
