package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateBizChain invokes the lto.UpdateBizChain API synchronously
func (client *Client) UpdateBizChain(request *UpdateBizChainRequest) (response *UpdateBizChainResponse, err error) {
	response = CreateUpdateBizChainResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateBizChainWithChan invokes the lto.UpdateBizChain API asynchronously
func (client *Client) UpdateBizChainWithChan(request *UpdateBizChainRequest) (<-chan *UpdateBizChainResponse, <-chan error) {
	responseChan := make(chan *UpdateBizChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateBizChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateBizChainWithCallback invokes the lto.UpdateBizChain API asynchronously
func (client *Client) UpdateBizChainWithCallback(request *UpdateBizChainRequest, callback func(response *UpdateBizChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateBizChainResponse
		var err error
		defer close(result)
		response, err = client.UpdateBizChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateBizChainRequest is the request struct for api UpdateBizChain
type UpdateBizChainRequest struct {
	*requests.RpcRequest
	Remark     string `position:"Query" name:"Remark"`
	BizChainId string `position:"Query" name:"BizChainId"`
	Name       string `position:"Query" name:"Name"`
}

// UpdateBizChainResponse is the response struct for api UpdateBizChain
type UpdateBizChainResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateBizChainRequest creates a request to invoke UpdateBizChain API
func CreateUpdateBizChainRequest() (request *UpdateBizChainRequest) {
	request = &UpdateBizChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "UpdateBizChain", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateBizChainResponse creates a response to parse from UpdateBizChain response
func CreateUpdateBizChainResponse() (response *UpdateBizChainResponse) {
	response = &UpdateBizChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
