package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTopic invokes the mns_open.ListTopic API synchronously
func (client *Client) ListTopic(request *ListTopicRequest) (response *ListTopicResponse, err error) {
	response = CreateListTopicResponse()
	err = client.DoAction(request, response)
	return
}

// ListTopicWithChan invokes the mns_open.ListTopic API asynchronously
func (client *Client) ListTopicWithChan(request *ListTopicRequest) (<-chan *ListTopicResponse, <-chan error) {
	responseChan := make(chan *ListTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTopicWithCallback invokes the mns_open.ListTopic API asynchronously
func (client *Client) ListTopicWithCallback(request *ListTopicRequest, callback func(response *ListTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTopicResponse
		var err error
		defer close(result)
		response, err = client.ListTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTopicRequest is the request struct for api ListTopic
type ListTopicRequest struct {
	*requests.RpcRequest
	TopicName string           `position:"Query" name:"TopicName"`
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
}

// ListTopicResponse is the response struct for api ListTopic
type ListTopicResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListTopicRequest creates a request to invoke ListTopic API
func CreateListTopicRequest() (request *ListTopicRequest) {
	request = &ListTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "ListTopic", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTopicResponse creates a response to parse from ListTopic response
func CreateListTopicResponse() (response *ListTopicResponse) {
	response = &ListTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
